/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5224Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5219Writer
extends SCS5224Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int QUALITY_DRAFT = 1;
    public static final int QUALITY_NEAR_LETTER = 2;
    private static final byte[] BUS = new byte[]{43, -44, 3, 10, 1};
    private static final byte[] EUS = new byte[]{43, -44, 2, 14};
    private static final byte[] SPPS = new byte[]{43, -46, 6, 64, 0, 0, 0, 0};
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] PPM = new byte[]{43, -46, 10, 72, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHM = new byte[]{43, -46, 4, 17, 0, 0};
    private static final byte[] SCG = new byte[]{43, -47, 6, 1, 0, 0, 0, 0};
    private boolean underline_ = false;
    private double paperWidth = 8.5;
    private double paperLength = 11.0;
    private byte paper = 1;
    private byte sourceDrawer = 1;
    private byte destinationDrawer = 1;
    private byte quality_ = (byte)2;
    private double leftMargin_ = 0.0;
    private int codepage_ = 0;
    private int charset_ = 0;
    byte plex_ = 0;

    public SCS5219Writer(OutputStream out) {
        super(out);
    }

    public SCS5219Writer(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out, ccsid);
    }

    public SCS5219Writer(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        super(out, ccsid, system);
    }

    public SCS5219Writer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
    }

    public void endPage() throws IOException {
        if (this.underline_) {
            this.addToBuffer(EUS);
        }
        super.endPage();
    }

    void initPage() throws IOException {
        super.initPage();
        this.sendSPPS();
        this.sendPPM();
        this.setLeftMargin(this.leftMargin_);
        this.setUnderline(this.underline_);
        if (this.codepage_ != 0) {
            this.setCodePage(this.codepage_, this.charset_);
        }
    }

    private void sendPPM() throws IOException {
        byte[] cmd = PPM;
        cmd[6] = this.paper;
        cmd[7] = this.sourceDrawer;
        cmd[9] = this.destinationDrawer;
        cmd[10] = this.quality_;
        cmd[11] = this.plex_;
        this.addToBuffer(cmd);
        if (this.plex_ != 0) {
            this.plex_ = 0;
            cmd[11] = 0;
            this.addToBuffer(cmd);
        }
    }

    private void sendSPPS() throws IOException {
        int width = (int)(this.paperWidth * 1440.0);
        int length = (int)(this.paperLength * 1440.0);
        byte[] cmd = SPPS;
        cmd[4] = (byte)(width >> 8);
        cmd[5] = (byte)width;
        cmd[6] = (byte)(length >> 8);
        cmd[7] = (byte)length;
        this.addToBuffer(cmd);
    }

    public void setCodePage(int codepage, int charset) throws IOException {
        byte[] cmd = SCG;
        if (codepage != 0 && charset != 0) {
            this.codepage_ = codepage;
            this.charset_ = charset;
            cmd[4] = (byte)(charset >> 8);
            cmd[5] = (byte)charset;
            cmd[6] = (byte)(codepage >> 8);
            cmd[7] = (byte)codepage;
            this.addToBuffer(cmd);
        }
    }

    public void setCPI(int cpi) throws IOException {
        switch (cpi) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 12: {
                this.CPI = (byte)12;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            default: {
                String arg = "CPI (" + String.valueOf(cpi) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] cmd = SCD;
        cmd[cmd.length - 1] = this.CPI;
        this.addToBuffer(cmd);
    }

    public void setDestinationDrawer(int drawer) {
        if (drawer < 1 || drawer > 255) {
            String arg = "Drawer (" + String.valueOf(drawer) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.destinationDrawer = (byte)drawer;
    }

    public void setEnvelopeSize(double width, double length) {
        if (width < 0.1 || width > 14.0) {
            String arg = "Width (" + String.valueOf(width) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (length < 0.1 || length > 14.0) {
            String arg = "Length (" + String.valueOf(length) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.paper = (byte)2;
        this.paperWidth = width;
        this.paperLength = length;
    }

    public void setLeftMargin(double leftMargin) throws IOException {
        if (leftMargin < 0.0 || leftMargin > 14.0) {
            String arg = "Left margin (" + String.valueOf(leftMargin) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.leftMargin_ = leftMargin;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] cmd = SHM;
        int margin1440 = (int)(leftMargin * 1440.0);
        cmd[4] = (byte)(margin1440 >> 8);
        cmd[5] = (byte)margin1440;
        this.addToBuffer(cmd);
    }

    public void setPaperSize(double width, double length) {
        if (width < 0.1 || width > 14.0) {
            String arg = "Width (" + String.valueOf(width) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (length < 0.1 || length > 14.0) {
            String arg = "Length (" + String.valueOf(length) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.paper = 1;
        this.paperWidth = width;
        this.paperLength = length;
    }

    public void setQuality(int quality) {
        switch (quality) {
            case 1: 
            case 2: {
                this.quality_ = (byte)quality;
                break;
            }
            default: {
                String arg = "Quality (" + String.valueOf(quality) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }

    public void setSourceDrawer(int drawer) {
        if (drawer < 1 || drawer > 255) {
            String arg = "Drawer (" + String.valueOf(drawer) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.sourceDrawer = (byte)drawer;
    }

    public void setUnderline(boolean ul) throws IOException {
        this.underline_ = ul;
        if (this.pageStarted_) {
            if (this.underline_) {
                this.addToBuffer(BUS);
            } else {
                this.addToBuffer(EUS);
            }
        }
    }
}

