/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCArray;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class SQLArray
implements SQLData {
    static final String copyright = "Copyright (C) 2009-2010 International Business Machines Corporation and others.";
    private SQLData[] values_;
    private int arrayCount_ = 0;
    private SQLData contentTemplate_;
    private int elemDataTypeLen_ = 0;
    private int vrm_;
    private Object savedValue_ = null;

    SQLArray() {
    }

    public SQLArray(int elemDataTypeLen, SQLData contentTemplate, int vrm) {
        this.values_ = null;
        this.contentTemplate_ = contentTemplate;
        this.vrm_ = vrm;
        this.elemDataTypeLen_ = elemDataTypeLen;
    }

    public Object clone() {
        SQLArray cpy = new SQLArray(this.elemDataTypeLen_, this.contentTemplate_, this.vrm_);
        return cpy;
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter, boolean ignoreConversionErrors) throws SQLException {
        this.values_ = new SQLData[this.arrayCount_];
        for (int x = 0; x < this.arrayCount_; ++x) {
            this.values_[x] = (SQLData)this.contentTemplate_.clone();
            try {
                this.values_[x].convertFromRawBytes(rawBytes, offset, converter, true);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            offset += this.elemDataTypeLen_;
        }
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        for (int x = 0; x < this.arrayCount_; ++x) {
            if (this.values_ != null && this.values_[x] != null) {
                this.values_[x].convertToRawBytes(rawBytes, offset, ccsidConverter);
            } else {
                this.contentTemplate_.convertToRawBytes(rawBytes, offset, ccsidConverter);
            }
            offset += this.elemDataTypeLen_;
        }
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        Object[] data = (Object[])((Array)object).getArray();
        if (data == null) {
            data = new Object[]{};
        }
        this.arrayCount_ = data.length;
        this.values_ = new SQLData[this.arrayCount_];
        boolean isSQLData = false;
        if (this.arrayCount_ > 0 && data[0] != null && data instanceof SQLData[]) {
            isSQLData = true;
        }
        for (int x = 0; x < this.arrayCount_; ++x) {
            this.values_[x] = (SQLData)this.contentTemplate_.clone();
            Object inObj = isSQLData ? ((SQLData)data[x]).getObject() : data[x];
            if (inObj == null) {
                this.setElementNull(x);
                continue;
            }
            this.values_[x].set(inObj, calendar, scale);
        }
    }

    public int getActualSize() {
        int totalSize = 0;
        for (int x = 0; x < this.arrayCount_; ++x) {
            totalSize += this.values_[x].getActualSize();
        }
        return totalSize;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Reader getNCharacterStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public NClob getNClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Array getArray() throws SQLException {
        return new AS400JDBCArray(this.contentTemplate_.getTypeName(), this.values_, this.vrm_, null);
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 0;
    }

    public String getJavaClassName() {
        return "java.sql.Array";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "ARRAY";
    }

    public int getMaximumPrecision() {
        return 0;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 10000;
    }

    public int getElementNativeType() {
        return this.contentTemplate_.getNativeType();
    }

    public Object getObject() throws SQLException {
        return this.getArray();
    }

    public Object getBatchableObject() throws SQLException {
        return this.getArray();
    }

    public int getPrecision() {
        return 0;
    }

    public int getRadix() {
        return 0;
    }

    public int getSQLType() {
        return 39;
    }

    public int getScale() {
        return 0;
    }

    public int getTruncated() {
        return 0;
    }

    public void clearTruncated() {
    }

    public boolean getOutOfBounds() {
        return false;
    }

    public void clearOutOfBounds() {
    }

    public int getType() {
        return 2003;
    }

    public String getTypeName() {
        return "ARRAY";
    }

    public boolean isSigned() {
        if (this.values_ != null && this.values_.length > 0 && this.values_[0] != null) {
            return this.values_[0].isSigned();
        }
        return false;
    }

    public boolean isText() {
        if (this.values_ != null && this.values_.length > 0 && this.values_[0] != null) {
            return this.values_[0].isText();
        }
        return false;
    }

    public void setArrayCount(int count) {
        this.arrayCount_ = count;
    }

    public int getArrayCount() {
        return this.arrayCount_;
    }

    public void setElementNull(int element) {
        this.values_[element] = null;
    }

    public boolean isElementNull(int element) {
        return this.values_[element] == null;
    }

    public void updateSettings(SQLConversionSettings settings) {
    }

    public void saveValue() {
        this.savedValue_ = this.values_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

