/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDatalink
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int length_ = 0;
    private int maxLength_;
    private String value_;

    SQLDatalink(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.value_ = "";
    }

    public Object clone() {
        return new SQLDatalink(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(rawBytes, offset);
        this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset + 2, this.length_);
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.unsignedShortToByteArray(this.length_, rawBytes, offset);
        try {
            ccsidConverter.stringToByteArray(this.value_, rawBytes, offset + 2, this.length_);
        }
        catch (Exception e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof URL) {
            this.value_ = ((URL)object).toExternalForm();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.length_ = this.value_.length();
    }

    public int getSQLType() {
        return 9;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "java.net.URL";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "DATALINK";
    }

    public int getMaximumPrecision() {
        return 32717;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 396;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 70;
    }

    public String getTypeName() {
        return "DATALINK";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new URL(this.value_);
        }
        catch (MalformedURLException e) {
            JDError.throwSQLException((Object)this, "07006", e);
            return null;
        }
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        return this.value_;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        return this.value_;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() throws SQLException {
        this.savedValue_ = this.value_;
    }
}

