/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLInteger
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int value_ = 0;
    private int scale_;
    private BigDecimal bigDecimalValue_ = null;
    private int vrm_;

    SQLInteger(int vrm, SQLConversionSettings settings) {
        this(0, vrm, settings);
    }

    SQLInteger(int scale, int vrm, SQLConversionSettings settings) {
        super(settings);
        this.scale_ = scale;
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_));
        }
        this.vrm_ = vrm;
    }

    public Object clone() {
        return new SQLInteger(this.scale_, this.vrm_, this.settings_);
    }

    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToInt(rawBytes, offset);
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = this.bigDecimalValue_.intValue();
        }
    }

    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.intToByteArray(this.value_, rawBytes, offset);
    }

    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        block22: {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (object instanceof String) {
                boolean tryAgain = false;
                try {
                    long longValue = Long.parseLong((String)object);
                    if (longValue > Integer.MAX_VALUE) {
                        this.truncated_ = 4;
                        this.outOfBounds_ = true;
                        this.value_ = Integer.MAX_VALUE;
                    } else if (longValue < Integer.MIN_VALUE) {
                        this.truncated_ = 4;
                        this.outOfBounds_ = true;
                        this.value_ = Integer.MIN_VALUE;
                    } else {
                        this.value_ = (int)longValue;
                    }
                }
                catch (NumberFormatException e) {
                    tryAgain = true;
                }
                if (tryAgain) {
                    try {
                        double doubleValue = Double.valueOf((String)object);
                        if (doubleValue > 2.147483647E9) {
                            this.truncated_ = 4;
                            this.outOfBounds_ = true;
                            this.value_ = Integer.MAX_VALUE;
                            break block22;
                        }
                        if (doubleValue < -2.147483648E9) {
                            this.truncated_ = 4;
                            this.outOfBounds_ = true;
                            this.value_ = Integer.MIN_VALUE;
                            break block22;
                        }
                        this.value_ = (int)doubleValue;
                    }
                    catch (NumberFormatException e) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                }
            } else if (object instanceof Number) {
                long longValue = ((Number)object).longValue();
                if (longValue > Integer.MAX_VALUE) {
                    this.truncated_ = 4;
                    this.outOfBounds_ = true;
                    this.value_ = Integer.MAX_VALUE;
                } else if (longValue < Integer.MIN_VALUE) {
                    this.truncated_ = 4;
                    this.outOfBounds_ = true;
                    this.value_ = Integer.MIN_VALUE;
                } else {
                    this.value_ = (int)longValue;
                }
            } else if (object instanceof Boolean) {
                this.value_ = (Boolean)object == true ? 1 : 0;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        }
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = this.bigDecimalValue_.intValue();
        }
    }

    public void set(int value) {
        this.value_ = value;
    }

    public int getSQLType() {
        return 18;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 11;
    }

    public String getJavaClassName() {
        return "java.lang.Integer";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "INTEGER";
    }

    public int getMaximumPrecision() {
        return 10;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 496;
    }

    public int getPrecision() {
        return 10;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return this.scale_;
    }

    public int getType() {
        return 4;
    }

    public String getTypeName() {
        return "INTEGER";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 4;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            if (scale >= 0) {
                return this.bigDecimalValue_.setScale(scale);
            }
            return this.bigDecimalValue_;
        }
        if (scale <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(scale);
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0;
    }

    public byte getByte() throws SQLException {
        if (this.value_ > 127 || this.value_ < -128) {
            if (this.value_ > Short.MAX_VALUE || this.value_ < Short.MIN_VALUE) {
                this.truncated_ = 3;
                this.outOfBounds_ = true;
                if (this.vrm_ >= JDUtilities.vrm610) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
                if (this.vrm_ >= JDUtilities.vrm610) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.doubleValue();
        }
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.floatValue();
        }
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new Integer(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > Short.MAX_VALUE || this.value_ < Short.MIN_VALUE) {
            this.truncated_ = 2;
            this.outOfBounds_ = true;
            if (this.vrm_ >= JDUtilities.vrm610) {
                JDError.throwSQLException((Object)this, "07006");
            }
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Integer.toString(this.value_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Integer.toString(this.value_);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = new Integer(this.value_);
    }
}

