/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SocketContainerJSSE
extends SocketContainer {
    private SSLSocket sslSocket_;

    SocketContainerJSSE() {
    }

    void setProperties(Socket socket, String serviceName, String systemName, int port, SSLOptions options) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerJSSE: create SSLSocket");
        }
        SSLSocketFactory sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.sslSocket_ = (SSLSocket)sslFactory.createSocket(socket, systemName, port, true);
        if (SecureAS400.changeCipherSuites) {
            try {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "SocketContainerJSSE try to change cipher suites of current connection.");
                }
                String[] ciphers = this.sslSocket_.getEnabledCipherSuites();
                String[] protols = this.sslSocket_.getEnabledProtocols();
                if (Trace.isTraceOn()) {
                    int i;
                    Trace.log(1, "SocketContainerJSSE: enabeld SSL version:");
                    for (i = 0; protols != null && i < protols.length; ++i) {
                        Trace.log(1, protols[i]);
                    }
                    if (ciphers != null) {
                        Trace.log(1, "SocketContainerJSSE: cipher suites originally enabled:");
                        for (i = 0; i < ciphers.length; ++i) {
                            Trace.log(1, ciphers[i]);
                        }
                    }
                }
                this.sslSocket_.setEnabledCipherSuites(SecureAS400.newCipherSuites);
                String[] newCiphersEnabled = this.sslSocket_.getEnabledCipherSuites();
                if (newCiphersEnabled != null && Trace.isTraceOn()) {
                    Trace.log(1, "SocketContainerJSSE: cipher suitesnew enabled:");
                    for (int i = 0; i < newCiphersEnabled.length; ++i) {
                        Trace.log(1, newCiphersEnabled[i]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void close() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerJSSE: close");
        }
        this.sslSocket_.close();
    }

    InputStream getInputStream() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerJSSE: getInputStream");
        }
        return this.sslSocket_.getInputStream();
    }

    OutputStream getOutputStream() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerJSSE: getOutputStream");
        }
        return this.sslSocket_.getOutputStream();
    }

    int getSoTimeout() throws SocketException {
        return this.sslSocket_.getSoTimeout();
    }

    void setSoTimeout(int timeout) throws SocketException {
        this.sslSocket_.setSoTimeout(timeout);
    }
}

