/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.NPCPSelSplF;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class SpooledFileList
extends PrintObjectList
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String FORM_TYPE_FILTER = "formTypeFilter";
    private static final String QUEUE_FILTER = "queueFilter";
    private static final String USER_FILTER = "userFilter";
    private static final String USER_DATA_FILTER = "userDataFilter";
    private static final String END_DATE_FILTER = "endDateFilter";
    private static final String END_TIME_FILTER = "endTimeFilter";
    private static final String START_DATE_FILTER = "startDateFilter";
    private static final String START_TIME_FILTER = "startTimeFilter";
    private static final String JOB_SYSTEM_FILTER = "jobSystemFilter";

    public SpooledFileList() {
        super(1, new NPCPSelSplF());
    }

    public SpooledFileList(AS400 system) {
        super(1, new NPCPSelSplF(), system);
    }

    void chooseImpl() {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use SpooledFileList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)system.loadImpl2("com.ibm.as400.access.SpooledFileListImplRemote", "com.ibm.as400.access.SpooledFileListImplProxy");
        super.setImpl();
    }

    public String getFormTypeFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getFormType();
    }

    public String getQueueFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getQueue();
    }

    public String getUserFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getUser();
    }

    public String getUserDataFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getUserData();
    }

    public String getJobSystemFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getJobSystem();
    }

    public String getEndDateFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getEndDate();
    }

    public String getEndTimeFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getEndTime();
    }

    PrintObject newNPObject(NPCPID cpid, NPCPAttribute cpattr) {
        return new SpooledFile(this.system_, (NPCPIDSplF)cpid, cpattr);
    }

    public String getStartDateFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getStartDate();
    }

    public String getStartTimeFilter() {
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        return selectionCP.getStartTime();
    }

    public void setFormTypeFilter(String formTypeFilter) throws PropertyVetoException {
        if (formTypeFilter == null) {
            Trace.log(2, "Parameter 'formTypeFilter' is null");
            throw new NullPointerException(FORM_TYPE_FILTER);
        }
        if (formTypeFilter.length() > 10) {
            Trace.log(2, "Parameter 'formTypeFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("formTypeFilter(" + formTypeFilter + ")", 2);
        }
        String oldFormTypeFilter = this.getFormTypeFilter();
        this.vetos.fireVetoableChange(FORM_TYPE_FILTER, oldFormTypeFilter, formTypeFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setFormType(formTypeFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("formType", formTypeFilter);
        }
        this.changes.firePropertyChange(FORM_TYPE_FILTER, oldFormTypeFilter, formTypeFilter);
    }

    public void setQueueFilter(String queueFilter) throws PropertyVetoException {
        if (queueFilter == null) {
            Trace.log(2, "Parameter 'queueFilter' is null");
            throw new NullPointerException(QUEUE_FILTER);
        }
        String oldQueueFilter = this.getQueueFilter();
        this.vetos.fireVetoableChange(QUEUE_FILTER, oldQueueFilter, queueFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setQueue(queueFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("spooledFileQueue", queueFilter);
        }
        this.changes.firePropertyChange(QUEUE_FILTER, oldQueueFilter, queueFilter);
    }

    public void setJobSystemFilter(String jobSystemFilter) throws PropertyVetoException {
        if (jobSystemFilter == null) {
            Trace.log(2, "Parameter 'jobSystemFilter' is null");
            throw new NullPointerException(JOB_SYSTEM_FILTER);
        }
        String oldJobSystemFilter = this.getJobSystemFilter();
        this.vetos.fireVetoableChange(JOB_SYSTEM_FILTER, oldJobSystemFilter, jobSystemFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setJobSystem(jobSystemFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("jobSystem", jobSystemFilter);
        }
        this.changes.firePropertyChange(JOB_SYSTEM_FILTER, oldJobSystemFilter, jobSystemFilter);
    }

    public void setEndDateFilter(String endDateFilter) throws PropertyVetoException {
        if (endDateFilter == null) {
            Trace.log(2, "Parameter 'endDateFilter' is null");
            throw new NullPointerException(END_DATE_FILTER);
        }
        if (endDateFilter.length() > 7) {
            Trace.log(2, "Parameter 'endDateFilter' has invalid length.");
            throw new ExtendedIllegalArgumentException("endDateFilter(" + endDateFilter + ")", 1);
        }
        String oldEndDateFilter = this.getEndDateFilter();
        this.vetos.fireVetoableChange(END_DATE_FILTER, oldEndDateFilter, endDateFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setEndDate(endDateFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("endDate", endDateFilter);
        }
        this.changes.firePropertyChange(END_DATE_FILTER, oldEndDateFilter, endDateFilter);
    }

    public void setEndTimeFilter(String endTimeFilter) throws PropertyVetoException {
        if (endTimeFilter == null) {
            Trace.log(2, "Parameter 'endTimeFilter' is null");
            throw new NullPointerException(END_TIME_FILTER);
        }
        String oldEndTimeFilter = this.getEndTimeFilter();
        this.vetos.fireVetoableChange(END_TIME_FILTER, oldEndTimeFilter, endTimeFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setEndTime(endTimeFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("endTime", endTimeFilter);
        }
        this.changes.firePropertyChange(END_TIME_FILTER, oldEndTimeFilter, endTimeFilter);
    }

    public void setStartDateFilter(String startDateFilter) throws PropertyVetoException {
        if (startDateFilter == null) {
            Trace.log(2, "Parameter 'startDateFilter' is null");
            throw new NullPointerException(START_DATE_FILTER);
        }
        String oldStartDateFilter = this.getStartDateFilter();
        this.vetos.fireVetoableChange(START_DATE_FILTER, oldStartDateFilter, startDateFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setStartDate(startDateFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("startDate", startDateFilter);
        }
        this.changes.firePropertyChange(START_DATE_FILTER, oldStartDateFilter, startDateFilter);
    }

    public void setStartTimeFilter(String startTimeFilter) throws PropertyVetoException {
        if (startTimeFilter == null) {
            Trace.log(2, "Parameter 'startTimeFilter' is null");
            throw new NullPointerException(START_TIME_FILTER);
        }
        String oldStartTimeFilter = this.getStartTimeFilter();
        this.vetos.fireVetoableChange(START_TIME_FILTER, oldStartTimeFilter, startTimeFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setStartTime(startTimeFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("StartTime", startTimeFilter);
        }
        this.changes.firePropertyChange(START_TIME_FILTER, oldStartTimeFilter, startTimeFilter);
    }

    public void setUserFilter(String userFilter) throws PropertyVetoException {
        if (userFilter == null) {
            Trace.log(2, "Parameter 'userFilter' is null");
            throw new NullPointerException(USER_FILTER);
        }
        if (userFilter.length() > 10) {
            Trace.log(2, "Parameter 'userFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("userFilter(" + userFilter + ")", 1);
        }
        String oldUserFilter = this.getUserFilter();
        this.vetos.fireVetoableChange(USER_FILTER, oldUserFilter, userFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setUser(userFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("user", userFilter);
        }
        this.changes.firePropertyChange(USER_FILTER, oldUserFilter, userFilter);
    }

    public void setUserDataFilter(String userDataFilter) throws PropertyVetoException {
        if (userDataFilter == null) {
            Trace.log(2, "Parameter 'userDataFilter' is null");
            throw new NullPointerException(USER_DATA_FILTER);
        }
        if (userDataFilter.length() > 10) {
            Trace.log(2, "Parameter 'userDataFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("userDataFilter(" + userDataFilter + ")", 1);
        }
        String oldUserDataFilter = this.getUserDataFilter();
        this.vetos.fireVetoableChange(USER_DATA_FILTER, oldUserDataFilter, userDataFilter);
        NPCPSelSplF selectionCP = (NPCPSelSplF)this.getSelectionCP();
        selectionCP.setUserData(userDataFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("userData", userDataFilter);
        }
        this.changes.firePropertyChange(USER_DATA_FILTER, oldUserDataFilter, userDataFilter);
    }
}

