/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFile;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileOutputStreamImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SpooledFileOutputStream
extends OutputStream {
    private transient AS400 system_;
    private transient SpooledFileOutputStreamImpl impl_;

    public SpooledFileOutputStream(AS400 system, PrintParameterList options, PrinterFile printerFile, OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.chooseImpl();
        this.system_.connectService(1);
        PrinterFileImpl pfi = null;
        if (printerFile != null) {
            if (printerFile.getImpl() == null) {
                printerFile.chooseImpl();
            }
            pfi = (PrinterFileImpl)printerFile.getImpl();
        }
        OutputQueueImpl oqi = null;
        if (outputQueue != null) {
            if (outputQueue.getImpl() == null) {
                outputQueue.chooseImpl();
            }
            oqi = (OutputQueueImpl)outputQueue.getImpl();
        }
        this.impl_.createSpooledFileOutputStream(this.system_.getImpl(), options, pfi, oqi);
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use SpooledFileOutputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (SpooledFileOutputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.SpooledFileOutputStreamImplRemote", "com.ibm.as400.access.SpooledFileOutputStreamImplProxy");
    }

    public void close() throws IOException {
        this.impl_.close();
    }

    public void flush() throws IOException {
        this.impl_.flush();
    }

    public SpooledFile getSpooledFile() throws IOException {
        NPCPIDSplF spID;
        SpooledFile sf;
        block2: {
            sf = null;
            spID = this.impl_.getSpooledFile();
            try {
                spID.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTraceErrorOn()) break block2;
                Trace.log(2, "Error initializing converter for print object", (Throwable)e);
            }
        }
        sf = new SpooledFile(this.system_, spID, null);
        return sf;
    }

    public void write(int b) throws IOException {
        byte[] buffer1Byte_ = new byte[]{(byte)b};
        this.write(buffer1Byte_, 0, 1);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.impl_.write(data, offset, length);
    }
}

