/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class TokenManager {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    TokenManager() {
    }

    static byte[] getGSSToken(String systemName, String gssName) throws Exception {
        GSSCredential credential;
        GSSManager manager = (GSSManager)AS400.getGSSManager();
        if (manager == null) {
            manager = GSSManager.getInstance();
        } else if (Trace.traceOn_) {
            Trace.log(1, "Using custom GSS manager: '" + manager + "'");
        }
        if (Trace.isTraceOn()) {
            Oid[] mechs = manager.getMechs();
            Trace.log(1, "GSS number of mechs available: ", mechs.length);
            for (int i = 0; i < mechs.length; ++i) {
                Trace.log(1, mechs[i].toString());
            }
        }
        Oid krb5Mech = new Oid("1.2.840.113554.1.2.2");
        GSSName serverName = manager.createName("krbsvr400@" + systemName, GSSName.NT_HOSTBASED_SERVICE, krb5Mech);
        if (gssName.length() == 0) {
            credential = manager.createCredential(1);
        } else {
            GSSName userName = manager.createName(gssName, GSSName.NT_USER_NAME);
            credential = manager.createCredential(userName, 0, krb5Mech, 1);
        }
        GSSContext context = manager.createContext(serverName, krb5Mech, credential, 0);
        return context.initSecContext(new byte[0], 0, 0);
    }
}

