/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserIndexNativeImpl;
import com.ibm.as400.access.UserIndexNativeImplILE;
import java.io.IOException;
import java.util.Arrays;

public class UserIndex {
    public static final int FIND_EQUALS = 1;
    public static final int FIND_GREATER = 2;
    public static final int FIND_LESSER = 3;
    public static final int FIND_NOT_LESSER = 4;
    public static final int FIND_NOT_GREATER = 5;
    public static final int FIND_FIRST = 6;
    public static final int FIND_LAST = 7;
    public static final int FIND_BETWEEN = 8;
    public static final byte FIXED_LENGTH_ENTRIES = -58;
    public static final byte VARIABLE_LENGTH_ENTRIES = -27;
    public static final byte INSERTION_BY_KEY = -15;
    public static final byte NO_INSERTION_BY_KEY = -16;
    public static final byte IMMEDIATE_UPDATE = -15;
    public static final byte NO_IMMEDIATE_UPDATE = -16;
    public static final byte OPTIMIZE_FOR_RANDOM_REFERENCES = -16;
    public static final byte OPTIMIZE_FOR_SEQUENTIAL_REFERENCES = -15;
    public static final int RULE_INSERT = 1;
    public static final int RULE_INSERT_REPLACE = 2;
    public static final int RULE_INSERT_NO_REPLACE = 3;
    private static byte[] IDXA0100 = new byte[]{-55, -60, -25, -63, -16, -15, -16, -16};
    private boolean mustUseNativeMethods_ = false;
    AS400 system_;
    String path_;
    private byte[] insertKeyValueBytes_;
    private byte[] insertOptionBytes_;
    private byte entryLengthAttribute_;
    private int entryLength_;
    private int keyLength_;
    private int valueLength_;
    private int handle_;
    private byte[] objectNameBytes_;
    private byte[] findOptionBytes_;
    UserIndexNativeImpl impl_;

    public UserIndex(AS400 system, String path) throws Exception {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserIndex object.");
        }
        this.system_ = system;
        this.path_ = path;
        this.objectNameBytes_ = new byte[20];
        Arrays.fill(this.objectNameBytes_, (byte)64);
        if (path.indexOf("/QSYS.LIB/") == 0) {
            path = path.substring(9);
        }
        if (path.charAt(0) != '/') {
            throw new Exception("Path does not begin with / : " + path);
        }
        int libIndex = path.indexOf(".LIB/");
        if (libIndex < 2) {
            throw new Exception("Path does not contain .LIB / : " + path);
        }
        String lib = path.substring(1, libIndex);
        byte[] libBytes = lib.getBytes("IBM-037");
        int usridxIndex = path.indexOf(".USRIDX");
        if (usridxIndex < libIndex) {
            throw new Exception("Path does not contain .USRIDX / : " + path);
        }
        String indexName = path.substring(libIndex + 5, usridxIndex);
        byte[] indexNameBytes = indexName.getBytes("IBM-037");
        System.arraycopy(indexNameBytes, 0, this.objectNameBytes_, 0, indexNameBytes.length);
        System.arraycopy(libBytes, 0, this.objectNameBytes_, 10, libBytes.length);
        this.handle_ = 0;
        this.impl_ = new UserIndexNativeImplILE();
    }

    public void create(String extendedAttribute, byte entryLengthAttribute, int entryLength, byte keyInsertion, int keyLength, byte immediateUpdate, byte optimization, String authority, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectAlreadyExistsException, Exception {
        this.entryLengthAttribute_ = entryLengthAttribute;
        this.entryLength_ = entryLength;
        this.keyLength_ = keyLength;
        this.valueLength_ = this.entryLength_ - keyLength;
        byte[] extendedAttributeBytes = extendedAttribute.getBytes("IBM-037");
        byte[] publicAuthorityBytes = authority.getBytes("IBM-037");
        byte[] descriptionBytes = description.getBytes("IBM-037");
        int valueLength = entryLength - keyLength;
        if (valueLength <= 0) {
            throw new Exception("Entry lentgh attribute of " + entryLength + " not correct for key length of " + keyLength);
        }
        if (this.entryLengthAttribute_ != -58) {
            throw new Exception("Entry lenth attribute of " + entryLengthAttribute + " not supported:  Valid values = " + -58);
        }
        this.handle_ = this.impl_.createAndOpen(this.objectNameBytes_, extendedAttributeBytes, entryLengthAttribute, entryLength, keyInsertion, keyLength, immediateUpdate, optimization, publicAuthorityBytes, descriptionBytes);
    }

    public void delete() {
        this.impl_.delete(this.handle_, this.objectNameBytes_);
        this.handle_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEntry(String key, String value, int insertionRuleOption) throws Exception {
        byte[] keyBytes = key.getBytes("IBM-037");
        byte[] valueBytes = value.getBytes("IBM-037");
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.entryLengthAttribute_ == -58) {
            if (valueBytes.length > this.entryLength_ - this.keyLength_) {
                throw new Exception("value too long " + value);
            }
        } else {
            throw new Exception("EntryLengthAttribute of " + this.entryLengthAttribute_ + " Not yet supported");
        }
        if (this.insertOptionBytes_ == null) {
            this.insertOptionBytes_ = new byte[20];
        }
        if (this.insertKeyValueBytes_ == null) {
            this.insertKeyValueBytes_ = new byte[this.entryLength_];
        }
        byte[] byArray = this.insertKeyValueBytes_;
        synchronized (this.insertKeyValueBytes_) {
            Arrays.fill(this.insertKeyValueBytes_, (byte)64);
            if (this.entryLengthAttribute_ == -58) {
                System.arraycopy(keyBytes, 0, this.insertKeyValueBytes_, 0, keyBytes.length);
                System.arraycopy(valueBytes, 0, this.insertKeyValueBytes_, this.keyLength_, valueBytes.length);
            }
            UserIndex.resetOptionBytes(this.insertOptionBytes_);
            UserIndex.setOptionBytesRule(this.insertOptionBytes_, insertionRuleOption);
            UserIndex.setOptionBytesOccCount(this.insertOptionBytes_, 1);
            if (this.handle_ == 0) {
                this.open();
            }
            this.impl_.insertEntry(this.handle_, this.insertKeyValueBytes_, this.insertOptionBytes_);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void insertEntry(byte[] entryBytes, byte[] optionBytes) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (this.handle_ == 0) {
            this.open();
        }
        this.impl_.insertEntry(this.handle_, entryBytes, optionBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] findEntries(String key, int rule, int occCount) throws Exception {
        byte[] findOptionBytes;
        String[][] returnValue = null;
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.entryLengthAttribute_ != -58) {
            throw new Exception("Unsupported entryLengthAttribute=0x" + Integer.toHexString(0xFF & this.entryLengthAttribute_));
        }
        byte[] keyBytes = key.getBytes("IBM-037");
        byte[] outputBuffer = new byte[occCount * this.entryLength_];
        if (occCount == 1) {
            if (this.findOptionBytes_ == null) {
                this.findOptionBytes_ = new byte[40];
            }
            findOptionBytes = this.findOptionBytes_;
        } else {
            findOptionBytes = new byte[10 + 4 * occCount];
        }
        byte[] byArray = findOptionBytes;
        synchronized (findOptionBytes) {
            UserIndex.setOptionBytesOccCount(findOptionBytes, occCount);
            UserIndex.setOptionBytesRule(findOptionBytes, rule);
            UserIndex.setOptionBytesArgLength(findOptionBytes, keyBytes.length);
            this.impl_.findEntries(this.handle_, outputBuffer, findOptionBytes, keyBytes);
            int returnCount = UserIndex.getOptionBytesReturnCount(findOptionBytes);
            returnValue = new String[returnCount][];
            if (this.entryLengthAttribute_ == -58) {
                for (int i = 0; i < returnCount; ++i) {
                    int entryStart = i * this.entryLength_;
                    returnValue[i] = new String[2];
                    returnValue[i][0] = new String(outputBuffer, entryStart, this.keyLength_, "IBM-037");
                    returnValue[i][1] = new String(outputBuffer, entryStart + this.keyLength_, this.valueLength_, "IBM-037");
                }
            } else {
                throw new Exception("EntryLengthAttribute of " + this.entryLengthAttribute_ + " Not yet supported");
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return returnValue;
        }
    }

    public void findEntries(byte[] outputBytes, byte[] optionBytes, byte[] keyBytes) throws Exception {
        if (this.handle_ == 0) {
            this.open();
        }
        this.impl_.findEntries(this.handle_, outputBytes, optionBytes, keyBytes);
    }

    public String toString() {
        return "UserIndex " + this.path_;
    }

    public boolean isMustUseNativeMethods() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user index must use native methods:", this.mustUseNativeMethods_);
        }
        return this.mustUseNativeMethods_;
    }

    public void setMustUseNativeMethods(boolean useNativeMethods) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting if user index must use native methods:", useNativeMethods);
        }
        this.mustUseNativeMethods_ = useNativeMethods;
    }

    private void open() {
        this.handle_ = this.impl_.open(this.objectNameBytes_);
        byte[] outputBytes = new byte[60];
        this.impl_.getAttributes(outputBytes, IDXA0100, this.objectNameBytes_);
        this.entryLengthAttribute_ = outputBytes[28];
        this.entryLength_ = (0xFF & outputBytes[36]) * 0x1000000 + (0xFF & outputBytes[37]) * 65536 + (0xFF & outputBytes[38]) * 256 + (0xFF & outputBytes[39]);
        this.keyLength_ = (0xFF & outputBytes[44]) * 0x1000000 + (0xFF & outputBytes[45]) * 65536 + (0xFF & outputBytes[46]) * 256 + (0xFF & outputBytes[47]);
        this.valueLength_ = this.entryLength_ - this.keyLength_;
    }

    public static void resetOptionBytes(byte[] optionBytes) {
        Arrays.fill(optionBytes, (byte)0);
    }

    public static void setOptionBytesRule(byte[] optionBytes, int insertionRuleOption) {
        optionBytes[0] = 0;
        optionBytes[1] = (byte)(insertionRuleOption & 0xFF);
    }

    public static void setOptionBytesArgLength(byte[] optionBytes, int argLength) {
        optionBytes[2] = (byte)(argLength / 256 & 0xFF);
        optionBytes[3] = (byte)(argLength & 0xFF);
    }

    public static void setOptionBytesOccCount(byte[] optionBytes, int occurrenceCount) {
        optionBytes[6] = (byte)(occurrenceCount / 256 & 0xFF);
        optionBytes[7] = (byte)(occurrenceCount & 0xFF);
    }

    public static int getOptionBytesReturnCount(byte[] optionBytes) {
        return (optionBytes[8] & 0xFF) * 256 + (optionBytes[9] & 0xFF);
    }
}

