/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.OpenList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

final class OpenListEnumeration
implements Enumeration {
    private OpenList list_;
    private boolean closed_ = false;
    private int length_;
    private int counter_;
    private int listOffset_ = 0;
    private Object[] objectCache_;
    private int cachePosition_ = 0;

    OpenListEnumeration(OpenList list, int length) {
        this.list_ = list;
        this.length_ = length;
    }

    synchronized void close() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "OpenList closed enumeration: " + this);
        }
        this.closed_ = true;
    }

    public boolean hasMoreElements() {
        return this.closed_ && this.counter_ < this.listOffset_ || !this.closed_ && this.counter_ < this.length_;
    }

    public synchronized Object nextElement() {
        if (this.closed_ && this.counter_ >= this.listOffset_ || !this.closed_ && this.counter_ >= this.length_) {
            throw new NoSuchElementException();
        }
        if (this.objectCache_ == null || this.cachePosition_ >= this.objectCache_.length) {
            try {
                int blockSize = this.list_.getEnumerationBlockSize();
                this.objectCache_ = this.list_.getItems(this.listOffset_, blockSize);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Loaded next block in OpenListEnumeration: " + this.objectCache_.length + " messages at offset " + this.listOffset_ + " out of " + this.length_ + " total, using block size " + blockSize + ".");
                }
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while loading nextElement() in OpenListEnumeration:", (Throwable)e);
                }
                throw new NoSuchElementException();
            }
            this.cachePosition_ = 0;
            this.listOffset_ += this.objectCache_.length;
        }
        ++this.counter_;
        Object obj = this.objectCache_[this.cachePosition_];
        this.objectCache_[this.cachePosition_++] = null;
        if (this.counter_ >= this.length_) {
            this.closed_ = true;
            this.list_.remove(this);
            if (Trace.isTraceOn()) {
                Trace.log(1, "OpenListEnumeration reached last element: " + this);
            }
        }
        return obj;
    }
}

