/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.DataDescriptor;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.ProgramDescriptor;
import com.ibm.as400.data.RecordFormatDescriptor;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.StructDescriptor;
import java.util.Enumeration;
import java.util.Vector;

abstract class DocNodeDescriptor
implements Descriptor {
    protected PcmlDocNode m_docNode;

    public DocNodeDescriptor(PcmlDocNode node) {
        this.m_docNode = node;
    }

    public PcmlDocNode getDocNode() {
        return this.m_docNode;
    }

    public abstract String[] getAttributeList();

    public abstract String getAttributeValue(String var1);

    public Enumeration getChildren() {
        int nbrChildren = this.m_docNode.getNbrChildren();
        Vector<StructDescriptor> v = new Vector<StructDescriptor>(nbrChildren);
        if (nbrChildren > 0) {
            Enumeration dnChildren = this.m_docNode.getChildren();
            while (dnChildren.hasMoreElements()) {
                DocNodeDescriptor child;
                PcmlDocNode dnChild = (PcmlDocNode)dnChildren.nextElement();
                if (dnChild instanceof PcmlStruct) {
                    child = new StructDescriptor(dnChild);
                } else if (dnChild instanceof PcmlData) {
                    child = new DataDescriptor(dnChild);
                } else if (dnChild instanceof PcmlProgram) {
                    child = new ProgramDescriptor(dnChild);
                } else if (dnChild instanceof RfmlRecordFormat) {
                    child = new RecordFormatDescriptor(dnChild);
                } else {
                    Trace.log(2, "Unrecognized child element type: " + dnChild.getClass().getName());
                    throw new InternalErrorException(6);
                }
                v.addElement((StructDescriptor)child);
            }
        }
        return v.elements();
    }

    public Descriptor getDescriptor(String qualifiedName) {
        PcmlDocNode dn = (PcmlDocNode)this.m_docNode.getDoc().getElement(qualifiedName);
        if (dn == null) {
            return null;
        }
        if (dn instanceof PcmlStruct) {
            return new StructDescriptor(dn);
        }
        if (dn instanceof PcmlData) {
            return new DataDescriptor(dn);
        }
        if (dn instanceof PcmlProgram) {
            return new ProgramDescriptor(dn);
        }
        if (dn instanceof RfmlRecordFormat) {
            return new RecordFormatDescriptor(dn);
        }
        Trace.log(2, "Unrecognized element type: " + dn.getClass().getName());
        throw new InternalErrorException(6);
    }

    public String getName() {
        return this.m_docNode.getName();
    }

    public String getQualifiedName() {
        return this.m_docNode.getQualifiedName();
    }

    public String getTagName() {
        return this.m_docNode.getTagName();
    }

    public boolean hasChildren() {
        return this.m_docNode.hasChildren();
    }
}

