/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

class ParseException
extends Exception {
    Vector m_messages = new Vector();

    ParseException() {
    }

    ParseException(String s) {
        super(s);
    }

    void addMessage(String msg) {
        this.m_messages.addElement(msg);
    }

    public void reportErrors() {
        this.reportErrors(new PrintWriter(System.err, true));
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    private void reportErrors(PrintWriter writer) {
        int count = this.m_messages.size();
        for (int i = 0; i < count; ++i) {
            String msg;
            if (i == 0 && (msg = (String)this.m_messages.elementAt(i)) != null && msg.indexOf("java.io.FileNotFoundException") != -1 && msg.indexOf(".dtd") != -1) {
                count = 1;
            }
            writer.println((String)this.m_messages.elementAt(i));
        }
        if (count == 1) {
            writer.println(SystemResourceFinder.format("ONE_PARSE_ERROR"));
        } else {
            writer.println(SystemResourceFinder.format("MANY_PARSE_ERRORS", new Object[]{new Integer(count)}));
        }
        if (writer.checkError()) {
            Trace.log(2, "Error when reporting errors to PrintWriter.");
            System.err.println(this.toString());
        }
    }

    public String getMessage() {
        StringWriter writer = new StringWriter();
        this.reportErrors(new PrintWriter(writer));
        String msg = writer.toString();
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg;
    }
}

