/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDocRoot;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import java.util.Enumeration;

abstract class PcmlDocNode
extends PcmlNode {
    public final int PROGRAM = 1;
    public final int STRUCT = 2;
    public final int DATA = 3;
    public final int RECORDFORMAT = 5;
    public static final int UNSUPPORTED = 0;
    public static final int INHERIT = 1;
    public static final int INPUT = 2;
    public static final int OUTPUT = 3;
    public static final int INPUTOUTPUT = 4;
    static final long serialVersionUID = 2085968464631195453L;
    protected transient PcmlAttributeList m_XmlAttrs;
    private String m_Name;
    private String m_QualName;
    private String m_TagName;
    private int m_NodeType;
    private int m_Usage;
    private String m_Type;
    private String m_Struct;
    private String m_CondensedName;
    private boolean m_IsExtendedType;
    private int m_CountReps;

    public PcmlDocNode() {
        this.m_XmlAttrs = null;
        this.m_Name = null;
        this.m_QualName = null;
        this.m_TagName = "";
        this.m_CondensedName = "";
        this.m_IsExtendedType = false;
        this.m_NodeType = 1;
        this.m_CountReps = -10;
    }

    public PcmlDocNode(PcmlAttributeList attrs) {
        this.m_XmlAttrs = attrs;
        this.m_TagName = "";
        this.m_CondensedName = "";
        this.m_IsExtendedType = false;
        this.m_CountReps = -10;
        this.m_NodeType = 1;
        this.m_Name = this.getAttributeValue("name");
        this.m_QualName = null;
        this.setUsage(this.getAttributeValue("usage"));
        this.m_Type = this.getAttributeValue("type");
        this.m_Struct = this.getAttributeValue("struct");
    }

    public Object clone() {
        PcmlDocNode child = null;
        PcmlDocNode newChild = null;
        PcmlDocNode node = (PcmlDocNode)super.clone();
        node.m_QualName = null;
        Enumeration children = this.getChildren();
        while (children.hasMoreElements()) {
            child = (PcmlDocNode)children.nextElement();
            newChild = (PcmlDocNode)child.clone();
            node.addChild(newChild);
        }
        return node;
    }

    protected void addChild(PcmlNode child) {
        super.addChild(child);
        String qName = child.getQualifiedName();
        if (!qName.equals("") && this.getDoc() != null) {
            if (this.getDoc().containsElement(qName)) {
                this.getDoc().addPcmlSpecificationError("MULTIPLE_DEFINE", new Object[]{qName});
            }
            this.getRootNode().addElement(child);
        }
    }

    AS400 getAs400() {
        return this.getDoc().getAs400();
    }

    int getAs400VRM() throws PcmlException {
        return this.getDoc().getAs400VRM();
    }

    final PcmlDocument getDoc() {
        return (PcmlDocument)this.getRootNode();
    }

    public String getName() {
        if (this.m_Name == null) {
            return "";
        }
        return this.m_Name;
    }

    public String getQualifiedName() {
        if (this.m_QualName != null && !this.m_QualName.equals("")) {
            return this.m_QualName;
        }
        String myName = this.getName();
        if (this.getDoc() == null) {
            return "";
        }
        if (this.getParent() == null) {
            return "";
        }
        if (myName.equals("") && this.getParent().getParent() != null) {
            return "";
        }
        String ancestor = ((PcmlDocNode)this.getParent()).getQualifiedName();
        if (ancestor.equals("")) {
            if (this.getParent().getParent() != null) {
                return "";
            }
            this.m_QualName = myName;
            return this.m_QualName;
        }
        this.m_QualName = ancestor + "." + myName;
        return this.m_QualName;
    }

    public String getNameForException() {
        String ancestor;
        String myName = this.getName();
        if (this.getParent() == null) {
            return "";
        }
        if (myName.equals("")) {
            myName = "[" + Integer.toString(this.getChildNbr()) + "]";
        }
        if ((ancestor = ((PcmlDocNode)this.getParent()).getQualifiedName()).equals("")) {
            return myName;
        }
        return ancestor + "." + myName;
    }

    int getNodeType() {
        return this.m_NodeType;
    }

    protected void setNodeType(int theType) {
        this.m_NodeType = theType;
        switch (this.m_NodeType) {
            case 1: {
                this.m_TagName = "pcml";
                break;
            }
            case 5: {
                this.m_TagName = "rfml";
                break;
            }
            case 2: {
                this.m_TagName = "program";
                break;
            }
            case 6: {
                this.m_TagName = "recordformat";
                break;
            }
            case 3: {
                this.m_TagName = "struct";
                break;
            }
            case 4: {
                this.m_TagName = "data";
            }
        }
    }

    protected String getStructName() {
        return this.m_Struct;
    }

    protected String getType() {
        return this.m_Type;
    }

    public int getUsage() {
        if (this.m_Usage == 1) {
            if (this.getParent() == null) {
                return 4;
            }
            return ((PcmlDocNode)this.getParent()).getUsage();
        }
        return this.m_Usage;
    }

    String resolveRelativeName(String relativeName) {
        PcmlDocNode relativeNode = this.resolveRelativeNode(relativeName);
        if (relativeNode != null) {
            return relativeNode.getQualifiedName();
        }
        return null;
    }

    PcmlDocNode resolveRelativeNode(String relativeName) {
        PcmlDocRoot root = this.getRootNode();
        PcmlDocNode relativeNode = null;
        if (relativeName == null) {
            return null;
        }
        for (PcmlDocNode p = (PcmlDocNode)this.getParent(); p != null; p = (PcmlDocNode)p.getParent()) {
            String currentName = p.getQualifiedName();
            currentName = currentName.equals("") ? relativeName : currentName + "." + relativeName;
            relativeNode = (PcmlDocNode)root.getElement(currentName);
            if (relativeNode == null) continue;
            return relativeNode;
        }
        return null;
    }

    public String toString() {
        String myName = this.getQualifiedName();
        if (myName.equals("")) {
            return super.toString();
        }
        return super.toString() + ":" + myName;
    }

    String getTagName() {
        return this.m_TagName;
    }

    String getBracketedTagName() {
        return "<" + this.m_TagName + ">";
    }

    abstract String[] getAttributeList();

    protected String getAttributeValue(String attributeName) {
        return this.m_XmlAttrs.getAttributeValue(attributeName);
    }

    private void setUsage(String usage) {
        this.m_Usage = usage == null || usage.equals("") ? 1 : (usage.equals("inherit") ? 1 : (usage.equals("input") ? 2 : (usage.equals("output") ? 3 : (usage.equals("inputoutput") ? 4 : 0))));
    }

    protected void checkAttributes() {
        if (this.m_Name != null && (this.m_Name.indexOf(37) == 0 || this.m_Name.indexOf(47) == 0 || this.m_Name.indexOf(92) == 0 || this.m_Name.indexOf(58) == 0 || this.m_Name.indexOf(91) == 0 || this.m_Name.indexOf(46) > -1 || this.m_Name.indexOf(32) > -1)) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlDocNode.makeQuotedAttr("name", this.m_Name), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Usage == 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlDocNode.makeQuotedAttr("usage", this.getAttributeValue("usage")), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_NodeType == 1) {
            this.getDoc().addPcmlSpecificationError("BAD_TAG", new Object[]{this.getBracketedTagName(), this.getNameForException()});
        }
    }

    protected static String makeQuotedAttr(String attrName, String attrValue) {
        return attrName + "=\"" + attrValue + "\"";
    }

    protected static String makeQuotedAttr(String attrName, int attrValue) {
        return PcmlDocNode.makeQuotedAttr(attrName, Integer.toString(attrValue));
    }

    void setCondensedName(String condensedName) {
        this.m_CondensedName = condensedName;
    }

    String getCondensedName() {
        return this.m_CondensedName;
    }

    void setIsExtendedType(boolean extendedType) {
        this.m_IsExtendedType = extendedType;
    }

    boolean getIsExtendedType() {
        return this.m_IsExtendedType;
    }

    protected void setCountReps(int reps) {
        this.m_CountReps = reps;
    }

    protected int getCountReps() {
        return this.m_CountReps;
    }
}

