/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.RfmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XMLErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class RfmlSAXParser
extends DefaultHandler
implements EntityResolver {
    private transient RfmlDocument m_rootNode;
    private transient PcmlDocNode m_currentNode;
    private transient String m_docName;
    private transient XMLErrorHandler m_xh;

    RfmlSAXParser() {
    }

    private void augmentTree(PcmlDocNode RfmlElem, Stack recursionStack) {
        Enumeration children = RfmlElem.getChildren();
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            String structName;
            RfmlData dataNode;
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            if (child instanceof RfmlData && (dataNode = (RfmlData)child).getDataType() == 7 && dataNode.getNbrChildren() == 0 && (structName = dataNode.getStruct()) != null) {
                PcmlDocNode structNode = (PcmlDocNode)this.m_rootNode.getElement(structName);
                if (structNode instanceof RfmlStruct) {
                    if (recursionStack.search(structNode) != -1) {
                        this.m_rootNode.addPcmlSpecificationError("CIRCULAR_REFERENCE", new Object[]{structName, dataNode.getBracketedTagName(), dataNode.getNameForException()});
                    } else {
                        Enumeration structChildren = structNode.getChildren();
                        while (structChildren.hasMoreElements()) {
                            PcmlDocNode structChild = (PcmlDocNode)structChildren.nextElement();
                            PcmlDocNode newChild = (PcmlDocNode)structChild.clone();
                            dataNode.addChild(newChild);
                            this.m_rootNode.addToHashtable(newChild);
                        }
                    }
                } else if (structNode == null) {
                    this.m_rootNode.addPcmlSpecificationError("REF_NOT_FOUND", new Object[]{structName, "<struct>", dataNode.getBracketedTagName(), dataNode.getNameForException()});
                } else {
                    this.m_rootNode.addPcmlSpecificationError("REF_WRONG_TYPE", new Object[]{structName, "<struct>", dataNode.getBracketedTagName(), dataNode.getNameForException()});
                }
            }
            recursionStack.push(child);
            this.augmentTree(child, recursionStack);
            recursionStack.pop();
        }
    }

    private void checkAttributes(PcmlDocNode RfmlElem) {
        Enumeration children = RfmlElem.getChildren();
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            child.checkAttributes();
            this.checkAttributes(child);
        }
    }

    RfmlDocument getRfmlDocument() {
        return this.m_rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parse(String docName, ClassLoader loader) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException, SAXException {
        this.m_rootNode = null;
        this.m_currentNode = null;
        String qualDocName = docName.endsWith(".rfml") || docName.endsWith(".rfmlsrc") ? docName.substring(0, docName.lastIndexOf(46)) : docName;
        this.m_docName = qualDocName.substring(qualDocName.lastIndexOf(46) + 1);
        InputStream inStream = null;
        try {
            inStream = SystemResourceFinder.getRFMLDocument(docName, loader);
            if (this.m_xh == null) {
                this.m_xh = new XMLErrorHandler(this.m_docName, 0);
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(false);
            factory.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            SAXParser parser = factory.newSAXParser();
            try {
                XMLReader reader = parser.getXMLReader();
                reader.setErrorHandler(this.m_xh);
                reader.setEntityResolver(this);
                parser.parse(new InputSource(inStream), (DefaultHandler)this);
            }
            catch (SAXException e) {
                ParseException exc;
                if (Trace.isTraceErrorOn()) {
                    e.printStackTrace(Trace.getPrintWriter());
                }
                if ((exc = this.m_xh.getException()) != null) {
                    throw exc;
                }
                ParseException pe = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                pe.addMessage(e.getMessage());
                throw pe;
            }
            inStream.close();
            inStream = null;
            ParseException exc = this.m_xh.getException();
            if (exc != null) {
                throw exc;
            }
            this.augmentTree(this.m_rootNode, new Stack());
            this.checkAttributes(this.m_rootNode);
            if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                throw this.m_rootNode.getPcmlSpecificationException();
            }
            Object var11_11 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (inStream == null) throw throwable;
            inStream.close();
            throw throwable;
        }
        inStream.close();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        int finalSlashPos;
        String sysFile;
        if (systemId != null && systemId.length() > 0 && (sysFile = (finalSlashPos = systemId.lastIndexOf("/")) == -1 ? systemId : systemId.substring(finalSlashPos + 1)).equals("rfml.dtd")) {
            InputStream isHeader = SystemResourceFinder.getRFMLHeader();
            return new InputSource(isHeader);
        }
        try {
            return super.resolveEntity(publicId, systemId);
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (Exception ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startElement(String namespaceURI, String localname, String tagName, Attributes xmlAttrs) {
        PcmlDocNode newNode = null;
        PcmlAttributeList attrs = new PcmlAttributeList(xmlAttrs.getLength());
        for (int attr = 0; attr < xmlAttrs.getLength(); ++attr) {
            attrs.addAttribute(new PcmlAttribute(xmlAttrs.getQName(attr), xmlAttrs.getValue(attr), true));
        }
        newNode = tagName.equals("rfml") ? new RfmlDocument(attrs, this.m_docName) : (tagName.equals("recordformat") ? new RfmlRecordFormat(attrs) : (tagName.equals("struct") ? new RfmlStruct(attrs) : (tagName.equals("data") ? new RfmlData(attrs) : null)));
        if (newNode != null) {
            if (this.m_rootNode == null) {
                try {
                    this.m_rootNode = newNode;
                }
                catch (ClassCastException e) {
                    Trace.log(2, "Source document is not a well-formed RFML document.");
                    throw e;
                }
                this.m_currentNode = newNode;
            } else {
                this.m_currentNode.addChild(newNode);
                this.m_currentNode = newNode;
            }
        }
    }

    public void endElement(String namespaceURI, String localname, String element) {
        this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
    }

    public void warning(SAXParseException spe) throws SAXException {
        if (this.m_xh == null) {
            throw spe;
        }
        this.m_xh.warning(spe);
    }

    public void error(SAXParseException spe) throws SAXException {
        if (this.m_xh == null) {
            throw spe;
        }
        this.m_xh.error(spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        if (this.m_xh == null) {
            throw spe;
        }
        this.m_xh.fatalError(spe);
    }
}

