/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ResourceLoader;
import com.ibm.as400.data.SystemClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.MissingResourceException;

class SystemResourceFinder {
    public static final String m_pcmlExtension = ".pcml";
    public static final String m_pcmlSerializedExtension = ".pcml.ser";
    public static final String m_rfmlExtension = ".rfml";
    public static final String m_rfmlSerializedExtension = ".rfml.ser";
    private static final String m_rfmlHeaderName = "com/ibm/as400/data/rfml.dtd";
    private static final String m_pcmlHeaderName = "com/ibm/as400/data/pcml.dtd";
    private static int m_headerLineCount;
    private static ResourceLoader m_loader;

    SystemResourceFinder() {
    }

    public static final String format(String key) {
        return SystemResourceFinder.format(key, null);
    }

    public static final String format(String key, Object[] args) {
        if (args != null) {
            try {
                return MessageFormat.format(m_loader.getString(key), args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_loader.getString(key);
    }

    public static final String getString(String key) {
        return m_loader.getStringWithNoSubstitute(key);
    }

    public static final int getHeaderLineCount() {
        return m_headerLineCount;
    }

    private static void traceLoader(ClassLoader loader) {
        if (Trace.isTraceOn()) {
            Trace.log(7, "SystemResourceFinder loader is " + loader + ")");
        }
    }

    private static final InputStream loadResource(String docPath) {
        if (Trace.isTraceOn()) {
            Trace.log(7, "SystemResourceFinder.loadResource(" + docPath + ")");
        }
        InputStream stream = null;
        ClassLoader loader = SystemResourceFinder.getLoader1();
        if (loader != null) {
            if (Trace.isTraceOn()) {
                SystemResourceFinder.traceLoader(loader);
            }
            if ((stream = loader.getResourceAsStream(docPath)) != null) {
                if (Trace.isTraceOn()) {
                    Trace.log(7, "SystemResourceFinder.loadResource found " + docPath);
                }
                return new BufferedInputStream(stream);
            }
        }
        if ((loader = SystemResourceFinder.getLoader2()) != null) {
            if (Trace.isTraceOn()) {
                SystemResourceFinder.traceLoader(loader);
            }
            if ((stream = loader.getResourceAsStream(docPath)) != null) {
                if (Trace.isTraceOn()) {
                    Trace.log(7, "SystemResourceFinder.loadResource found " + docPath);
                }
                return new BufferedInputStream(stream);
            }
        }
        if ((loader = SystemResourceFinder.getLoader3()) != null) {
            if (Trace.isTraceOn()) {
                SystemResourceFinder.traceLoader(loader);
            }
            if ((stream = loader.getResourceAsStream(docPath)) != null) {
                if (Trace.isTraceOn()) {
                    Trace.log(7, "SystemResourceFinder.loadResource found " + docPath);
                }
                return new BufferedInputStream(stream);
            }
        }
        return null;
    }

    private static final ClassLoader getLoader1() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable t) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "Couldn't get current thread's context class loader: " + t.toString());
            }
            return null;
        }
    }

    private static final ClassLoader getLoader2() {
        try {
            Class<?> c = Class.forName("com.ibm.as400.data.SystemResourceFinder");
            try {
                return c.getClassLoader();
            }
            catch (Throwable t2) {
                if (Trace.isTraceOn()) {
                    Trace.log(7, "Couldn't get SystemResourceFinder class loader: " + t2.toString());
                }
                return null;
            }
        }
        catch (Throwable t) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "Couldn't get SystemResourceFinder class: " + t.toString());
            }
            return null;
        }
    }

    private static final ClassLoader getLoader3() {
        return new SystemClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InputStream getPCMLHeader() {
        InputStream stream;
        block16: {
            Exception e32;
            String docPath;
            block15: {
                docPath = m_pcmlHeaderName;
                stream = SystemResourceFinder.loadResource(docPath);
                if (stream == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{m_pcmlHeaderName}), m_pcmlHeaderName, "");
                }
                if (m_headerLineCount > 0) break block16;
                LineNumberReader lnr = null;
                try {
                    lnr = new LineNumberReader(new InputStreamReader(stream));
                    try {
                        String line = lnr.readLine();
                        while (line != null) {
                            ++m_headerLineCount;
                            line = lnr.readLine();
                        }
                    }
                    catch (IOException e2) {
                        Trace.log(7, "Error when reading input stream in getPCMLHeader", (Throwable)e2);
                    }
                    Object var5_5 = null;
                    if (lnr == null) break block15;
                }
                catch (Throwable throwable) {
                    Exception e32;
                    Object var5_6 = null;
                    if (lnr != null) {
                        try {
                            lnr.close();
                            stream = null;
                        }
                        catch (Exception e32) {
                            Trace.log(2, e32);
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e32) {
                            Trace.log(2, e32);
                        }
                    }
                    throw throwable;
                }
                try {
                    lnr.close();
                    stream = null;
                }
                catch (Exception e32) {
                    Trace.log(2, e32);
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e32) {
                    Trace.log(2, e32);
                }
            }
            stream = SystemResourceFinder.loadResource(docPath);
        }
        return stream;
    }

    public static synchronized InputStream getXPCMLTransformFile(String fileName) {
        String docPath = "com/ibm/as400/data/" + fileName;
        InputStream stream = SystemResourceFinder.loadResource(docPath);
        if (stream == null) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "XSL file not found.");
            }
            throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{fileName}), fileName, "");
        }
        return stream;
    }

    static synchronized InputStream getPCMLDocument(String docName, ClassLoader loader) throws MissingResourceException {
        String docPath = null;
        if (docName.endsWith(m_pcmlExtension) || docName.endsWith(".pcmlsrc") || docName.endsWith(".xpcml") || docName.endsWith(".xpcmlsrc")) {
            String baseName = docName.substring(0, docName.lastIndexOf(46));
            String extension = docName.substring(docName.lastIndexOf(46));
            docPath = baseName.replace('.', '/') + extension;
        } else {
            docPath = docName.replace('.', '/') + m_pcmlExtension;
        }
        InputStream stream = null;
        if (loader != null) {
            stream = loader.getResourceAsStream(docPath);
            if (stream != null) {
                return new BufferedInputStream(stream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{docName}), docName, "");
        }
        stream = SystemResourceFinder.loadResource(docPath);
        if (stream != null) {
            return stream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{docName}), docName, "");
    }

    static synchronized InputStream getSerializedPCMLDocument(String docName, ClassLoader loader) throws MissingResourceException {
        String docPath = docName.replace('.', '/') + m_pcmlSerializedExtension;
        InputStream stream = null;
        if (loader != null) {
            stream = loader.getResourceAsStream(docPath);
            if (stream != null) {
                return new BufferedInputStream(stream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_PCML_NOT_FOUND", new Object[]{docName}), docName, "");
        }
        stream = SystemResourceFinder.loadResource(docPath);
        if (stream != null) {
            return stream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_PCML_NOT_FOUND", new Object[]{docName}), docName, "");
    }

    public static synchronized InputStream getRFMLHeader() {
        String docPath = m_rfmlHeaderName;
        InputStream stream = SystemResourceFinder.loadResource(docPath);
        if (stream == null) {
            throw new MissingResourceException(SystemResourceFinder.format("DTD_NOT_FOUND", new Object[]{"RFML", m_rfmlHeaderName}), m_rfmlHeaderName, "");
        }
        return stream;
    }

    static synchronized InputStream getRFMLDocument(String docName, ClassLoader loader) throws MissingResourceException {
        String docPath = null;
        if (docName.endsWith(m_rfmlExtension) || docName.endsWith(".rfmlsrc")) {
            String baseName = docName.substring(0, docName.lastIndexOf(46));
            String extension = docName.substring(docName.lastIndexOf(46));
            docPath = baseName.replace('.', '/') + extension;
        } else {
            docPath = docName.replace('.', '/') + m_rfmlExtension;
        }
        InputStream stream = null;
        if (loader != null) {
            stream = loader.getResourceAsStream(docPath);
            if (stream != null) {
                return new BufferedInputStream(stream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{"RFML", docName}), docName, "");
        }
        stream = SystemResourceFinder.loadResource(docPath);
        if (stream != null) {
            return stream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{"RFML", docName}), docName, "");
    }

    static synchronized InputStream getSerializedRFMLDocument(String docName, ClassLoader loader) throws MissingResourceException {
        String docPath = docName.replace('.', '/') + m_rfmlSerializedExtension;
        InputStream stream = null;
        if (loader != null) {
            stream = loader.getResourceAsStream(docPath);
            if (stream != null) {
                return new BufferedInputStream(stream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_XML_NOT_FOUND", new Object[]{"RFML", docName}), docName, "");
        }
        stream = SystemResourceFinder.loadResource(docPath);
        if (stream != null) {
            return stream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_XML_NOT_FOUND", new Object[]{"RFML", docName}), docName, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isXPCML(String docName, ClassLoader loader) throws MissingResourceException, IOException {
        InputStream stream;
        boolean isXPCML;
        block17: {
            String docPath = null;
            if (docName.endsWith(m_pcmlExtension) || docName.endsWith(".pcmlsrc") || docName.endsWith(".xpcml") || docName.endsWith(".xpcmlsrc")) {
                String baseName = docName.substring(0, docName.lastIndexOf(46));
                String extension = docName.substring(docName.lastIndexOf(46));
                docPath = baseName.replace('.', '/') + extension;
            } else {
                docPath = docName.replace('.', '/') + m_pcmlExtension;
            }
            isXPCML = false;
            stream = null;
            BufferedReader lnr = null;
            try {
                if (loader != null && (stream = loader.getResourceAsStream(docPath)) == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{docName}), docName, "");
                }
                if (stream == null && (stream = SystemResourceFinder.loadResource(docPath)) == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{docName}), docName, "");
                }
                lnr = new LineNumberReader(new InputStreamReader(stream));
                try {
                    String line = ((LineNumberReader)lnr).readLine();
                    boolean found = false;
                    while (line != null && !found) {
                        if (line.indexOf("<xpcml") != -1) {
                            found = true;
                            isXPCML = true;
                            continue;
                        }
                        if (line.indexOf("<pcml") != -1) {
                            found = true;
                            isXPCML = false;
                            continue;
                        }
                        line = ((LineNumberReader)lnr).readLine();
                    }
                }
                catch (IOException e) {
                    Trace.log(7, "Error when reading input stream in isXPCML");
                    throw e;
                }
                Object var9_10 = null;
                if (lnr == null) break block17;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (lnr != null) {
                    try {
                        lnr.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    stream.close();
                }
                throw throwable;
            }
            try {
                lnr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (stream != null) {
            stream.close();
        }
        return isXPCML;
    }

    static {
        m_loader = new ResourceLoader();
        m_loader.setResourceName("com.ibm.as400.data.DAMRI");
    }
}

