/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Vector;

class OptionsValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private char falsePhysicalValue_;
    private char truePhysicalValue_;
    private String[] possibleLogicalValues_;

    public OptionsValueMap(char falsePhysicalValue, char truePhysicalValue, String[] possibleLogicalValues) {
        this.falsePhysicalValue_ = falsePhysicalValue;
        this.truePhysicalValue_ = truePhysicalValue;
        this.possibleLogicalValues_ = possibleLogicalValues;
    }

    public Object ltop(Object logicalValue, AS400 system) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(logicalValue instanceof String[])) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        String[] asArray = (String[])logicalValue;
        StringBuffer buffer = new StringBuffer(this.possibleLogicalValues_.length);
        for (int i = 0; i < this.possibleLogicalValues_.length; ++i) {
            boolean found = false;
            for (int j = 0; j < asArray.length && !found; ++j) {
                if (!this.possibleLogicalValues_[i].equals(asArray[j])) continue;
                found = true;
                break;
            }
            buffer.append(found ? this.truePhysicalValue_ : this.falsePhysicalValue_);
        }
        return buffer.toString();
    }

    public Object ptol(Object physicalValue, AS400 system) {
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        if (!(physicalValue instanceof String)) {
            throw new ExtendedIllegalArgumentException("physicalValue", 2);
        }
        String physicalValueS = (String)physicalValue;
        int length = Math.max(physicalValueS.length(), this.possibleLogicalValues_.length);
        Vector<String> logicalValuesV = new Vector<String>(length);
        for (int i = 0; i < length; ++i) {
            if (physicalValueS.charAt(i) != this.truePhysicalValue_) continue;
            logicalValuesV.addElement(this.possibleLogicalValues_[i]);
        }
        Object[] logicalValues = new String[logicalValuesV.size()];
        logicalValuesV.copyInto(logicalValues);
        return logicalValues;
    }
}

