/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Date;

public class RIFSFile
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static final String ICON_BASE_NAME_ = "RIFSFile";
    private static final String PRESENTATION_KEY_ = "IFSFILE";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "IFSFILE");
    public static final String ABSOLUTE_PATH = "ABSOLUTE_PATH";
    public static final String CANONICAL_PATH = "CANONICAL_PATH";
    public static final String CAN_READ = "CAN_READ";
    public static final String CAN_WRITE = "CAN_WRITE";
    public static final String CCSID = "CCSID";
    public static final String CREATED = "CREATED";
    public static final String EXISTS = "EXISTS";
    public static final String IS_ABSOLUTE = "IS_ABSOLUTE";
    public static final String IS_DIRECTORY = "IS_DIRECTORY";
    public static final String IS_FILE = "IS_FILE";
    public static final String IS_HIDDEN = "IS_HIDDEN";
    public static final String IS_READ_ONLY = "IS_READ_ONLY";
    public static final String LAST_ACCESSED = "LAST_ACCESSED";
    public static final String LAST_MODIFIED = "LAST_MODIFIED";
    public static final String LENGTH = "LENGTH";
    public static final String NAME = "NAME";
    public static final String OWNERID = "OWNERID";
    public static final String PARENT = "PARENT";
    public static final String PATH = "PATH";
    public static final String TYPE = "TYPE";
    public static final String TYPE_DIRECTORY = "*DIRECTORY";
    public static final String TYPE_FILE = "*FILE";
    public static final String TYPE_UNKNOWN = "*UNKNOWN";
    private IFSFile file_ = new IFSFile();
    private String path_ = null;

    public RIFSFile() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    public RIFSFile(AS400 system, String path) {
        this();
        try {
            this.setSystem(system);
            this.setPath(path);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    RIFSFile(IFSFile file) {
        this();
        try {
            this.setSystem(file.getSystem());
            this.file_ = file;
            this.path_ = file.getPath();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values) throws ResourceException {
        super.commitAttributeChanges(attributeIDs, values);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            for (int i = 0; i < attributeIDs.length; ++i) {
                boolean success = true;
                if (attributeIDs[i].equals(IS_HIDDEN)) {
                    success = this.file_.setHidden((Boolean)values[i]);
                } else if (attributeIDs[i].equals(LAST_MODIFIED)) {
                    success = this.file_.setLastModified(((Date)values[i]).getTime());
                } else if (attributeIDs[i].equals(IS_READ_ONLY)) {
                    success = this.file_.setReadOnly((Boolean)values[i]);
                } else {
                    throw new ExtendedIllegalArgumentException("attributeIDs[" + i + "](" + attributeIDs[i] + ")", 2);
                }
                if (success) continue;
                throw new ResourceException(2);
            }
        }
        catch (Exception e) {
            throw new ResourceException(2, (Throwable)e);
        }
    }

    static Object computeResourceKey(AS400 system, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RIFSFile.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(system.getUserId());
        buffer.append(':');
        buffer.append(path);
        return buffer.toString();
    }

    public void delete() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            boolean success = this.file_.delete();
            if (!success) {
                throw new ResourceException(4);
            }
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    protected void establishConnection() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        super.establishConnection();
    }

    protected void freezeProperties() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.file_.getName());
        presentation.setFullName(this.file_.getPath());
        if (this.getResourceKey() == null) {
            this.setResourceKey(RIFSFile.computeResourceKey(this.getSystem(), this.file_.getPath()));
        }
        super.freezeProperties();
    }

    public Object getAttributeUnchangedValue(Object attributeID) throws ResourceException {
        Object value = super.getAttributeUnchangedValue(attributeID);
        if (value == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            try {
                if (attributeID.equals(ABSOLUTE_PATH)) {
                    return this.file_.getAbsolutePath();
                }
                if (attributeID.equals(CANONICAL_PATH)) {
                    return this.file_.getCanonicalPath();
                }
                if (attributeID.equals(CAN_READ)) {
                    return this.file_.canRead() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(CAN_WRITE)) {
                    return this.file_.canWrite() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(CCSID)) {
                    return new Integer(this.file_.getCCSID());
                }
                if (attributeID.equals(CREATED)) {
                    return new Date(this.file_.created());
                }
                if (attributeID.equals(EXISTS)) {
                    return this.file_.exists() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(IS_ABSOLUTE)) {
                    return this.file_.isAbsolute() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(IS_DIRECTORY)) {
                    return this.file_.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(IS_FILE)) {
                    return this.file_.isFile() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(IS_HIDDEN)) {
                    return this.file_.isHidden() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(IS_READ_ONLY)) {
                    return this.file_.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (attributeID.equals(LAST_ACCESSED)) {
                    return new Date(this.file_.lastAccessed());
                }
                if (attributeID.equals(LAST_MODIFIED)) {
                    return new Date(this.file_.lastModified());
                }
                if (attributeID.equals(LENGTH)) {
                    return new Long(this.file_.length());
                }
                if (attributeID.equals(NAME)) {
                    return this.file_.getName();
                }
                if (attributeID.equals(OWNERID)) {
                    return new Integer(this.file_.getOwnerId());
                }
                if (attributeID.equals(PARENT)) {
                    return this.file_.getParent();
                }
                if (attributeID.equals(PATH)) {
                    return this.file_.getPath();
                }
                if (attributeID.equals(TYPE)) {
                    if (this.file_.isDirectory()) {
                        return TYPE_DIRECTORY;
                    }
                    if (this.file_.isFile()) {
                        return TYPE_FILE;
                    }
                    return TYPE_UNKNOWN;
                }
                throw new ExtendedIllegalArgumentException("attributeID(" + attributeID + ")", 2);
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
        }
        return value;
    }

    public String getPath() {
        return this.path_;
    }

    public void refreshAttributeValues() throws ResourceException {
        super.refreshAttributeValues();
        this.file_.clearCachedAttributes();
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.file_.getPath();
        try {
            this.path_ = path;
            String tempPath = path.replace(IFSJavaFile.separatorChar, '/');
            this.file_.setPath(tempPath);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.firePropertyChange("path", oldValue, path);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        super.setSystem(system);
        this.file_.setSystem(system);
    }

    static {
        attributes_.add((Object)ABSOLUTE_PATH, String.class, true);
        attributes_.add((Object)CANONICAL_PATH, String.class, true);
        attributes_.add((Object)CAN_READ, Boolean.class, true);
        attributes_.add((Object)CAN_WRITE, Boolean.class, true);
        attributes_.add((Object)CCSID, Integer.class, true);
        attributes_.add((Object)CREATED, Date.class, true);
        attributes_.add((Object)EXISTS, Boolean.class, true);
        attributes_.add((Object)IS_ABSOLUTE, Boolean.class, true);
        attributes_.add((Object)IS_DIRECTORY, Boolean.class, true);
        attributes_.add((Object)IS_FILE, Boolean.class, true);
        attributes_.add((Object)IS_HIDDEN, Boolean.class, false);
        attributes_.add((Object)IS_READ_ONLY, Boolean.class, false);
        attributes_.add((Object)LAST_ACCESSED, Date.class, true);
        attributes_.add((Object)LAST_MODIFIED, Date.class, false);
        attributes_.add((Object)LENGTH, Long.class, true);
        attributes_.add((Object)NAME, String.class, true);
        attributes_.add((Object)OWNERID, Integer.class, true);
        attributes_.add((Object)PARENT, String.class, true);
        attributes_.add((Object)PATH, String.class, true);
        attributes_.add(TYPE, String.class, true, new Object[]{TYPE_DIRECTORY, TYPE_FILE, TYPE_UNKNOWN}, null, true);
    }
}

