/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.security.auth.AuthenticationSystem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Vector;

public abstract class AS400Principal
implements Principal,
Serializable {
    static final long serialVersionUID = 4L;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    private transient Vector credentialListeners_ = new Vector();
    private AS400 system_ = null;

    public AS400Principal() {
        this.initTransient();
    }

    public AS400Principal(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changes_.firePropertyChange(propertyName, oldValue, newValue);
    }

    void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetos_.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public String getName() {
        return this.getUserProfileName();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public User getUser() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        if (this.getSystem() == null) {
            Trace.log(2, "Required property 'system' not set.");
            throw new ExtendedIllegalStateException(4);
        }
        return new User(this.getSystem(), this.getUserProfileName());
    }

    public String getUserProfileName() {
        return "";
    }

    void initTransient() {
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        AS400 old = this.getSystem();
        this.fireVetoableChange("system", old, system);
        this.system_ = system;
        this.firePropertyChange("system", old, system);
    }
}

