/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.ProfileHandleImpl;
import java.beans.PropertyVetoException;

public final class ProfileHandleCredential
extends AS400Credential {
    static final long serialVersionUID = 4L;
    private byte[] handle_ = null;
    public static final int HANDLE_LENGTH = 12;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileHandleCredential)) {
            return false;
        }
        return this.hashCode() == ((ProfileHandleCredential)o).hashCode();
    }

    public byte[] getHandle() {
        return this.handle_;
    }

    public int hashCode() {
        int hash = 19913;
        if (this.handle_ != null) {
            for (int i = 0; i < this.handle_.length; ++i) {
                hash ^= this.handle_[i];
            }
        }
        hash ^= this.isPrivate() ? 13431 : 14427;
        if (this.getPrincipal() != null) {
            hash ^= this.getPrincipal().hashCode();
        }
        if (this.getSystem() != null) {
            hash ^= this.getSystem().getSystemName().hashCode();
        }
        return hash;
    }

    String implClassNameNative() {
        return "com.ibm.as400.access.ProfileHandleImplNative";
    }

    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.ProfileHandleImplRemote";
    }

    void initTransient() {
        super.initTransient();
        this.handle_ = null;
    }

    void invalidateProperties() {
        super.invalidateProperties();
        this.handle_ = null;
    }

    public void setHandle() throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        ProfileHandleImpl impl = (ProfileHandleImpl)this.getImplPrimitive();
        this.setHandle(impl.getCurrentHandle());
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setHandle(byte[] bytes) throws PropertyVetoException {
        this.validatePropertyChange("handle");
        if (bytes != null && bytes.length != 12) {
            Trace.log(2, "Handle of length " + bytes.length + " not valid ");
            throw new ExtendedIllegalArgumentException("bytes", 1);
        }
        byte[] old = this.getHandle();
        this.fireVetoableChange("handle", old, bytes);
        this.handle_ = bytes;
        this.firePropertyChange("handle", old, bytes);
    }

    boolean typeIsStandalone() {
        return true;
    }

    void validateProperties() {
        super.validateProperties();
        this.validatePropertySet("handle", this.getHandle());
    }
}

