/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400CredentialImplRemote;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class ProfileTokenImplRemote
extends AS400CredentialImplRemote
implements ProfileTokenImpl {
    ProfileTokenImplRemote() {
    }

    public void destroy() throws DestroyFailedException {
        this.removeFromSystem();
        super.destroy();
    }

    public byte[] generateToken(String uid, String pwd, int type, int timeoutInterval) throws RetrieveFailedException {
        AS400 sys = this.getCredential().getSystem();
        try {
            if (sys.getVRM() >= 328448) {
                Trace.log(2, "setToken(String,String,in,int) deprecated.Use setTokenExtended(String,String,int,int).");
                throw new ExtendedIllegalArgumentException("Method deprecated", 2);
            }
        }
        catch (AS400SecurityException se) {
            throw new RetrieveFailedException(se.getReturnCode());
        }
        catch (IOException ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
        byte[] tkn = null;
        try {
            tkn = sys.getProfileToken(uid, pwd, type, timeoutInterval).getToken();
        }
        catch (AS400SecurityException se) {
            throw new RetrieveFailedException(se.getReturnCode());
        }
        catch (Exception e) {
            AuthenticationSystem.handleUnexpectedException(e);
        }
        return tkn;
    }

    public byte[] generateToken(String uid, int pwdSpecialValue, int type, int timeoutInterval) throws RetrieveFailedException {
        String pwd;
        switch (pwdSpecialValue) {
            case 1: {
                pwd = "*NOPWD    ";
                break;
            }
            case 2: {
                pwd = "*NOPWDCHK ";
                break;
            }
            default: {
                Trace.log(2, "Password special value = " + pwdSpecialValue + " is not valid.");
                throw new ExtendedIllegalArgumentException("Password special value", 2);
            }
        }
        AS400 sys = this.getCredential().getSystem();
        ProgramParameter[] parmlist = new ProgramParameter[6];
        parmlist[0] = new ProgramParameter(32);
        parmlist[1] = new ProgramParameter(ProfileTokenImplRemote.stringToByteArray(uid.toUpperCase()));
        try {
            parmlist[2] = new ProgramParameter(CharConverter.stringToByteArray(37, sys, pwd));
        }
        catch (UnsupportedEncodingException uee) {
            Trace.log(2, "Unexpected UnsupportedEncodingException: ", (Throwable)uee);
            throw new RetrieveFailedException();
        }
        parmlist[3] = new ProgramParameter(BinaryConverter.intToByteArray(timeoutInterval));
        parmlist[4] = new ProgramParameter(CharConverter.stringToByteArray(sys, new Integer(type).toString()));
        parmlist[5] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        ProgramCall programCall = new ProgramCall(sys);
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENPT", "PGM"), parmlist);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENPT failed.");
                throw new RetrieveFailedException(programCall.getMessageList());
            }
        }
        catch (IOException ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
        catch (InterruptedException ine) {
            AuthenticationSystem.handleUnexpectedException(ine);
        }
        catch (Exception e) {
            throw new RetrieveFailedException();
        }
        return parmlist[0].getOutputData();
    }

    public byte[] generateTokenExtended(String uid, String pwd, int type, int timeoutInterval) throws RetrieveFailedException {
        byte[] tkn = null;
        try {
            tkn = this.getCredential().getSystem().getProfileToken(uid, pwd, type, timeoutInterval).getToken();
        }
        catch (AS400SecurityException se) {
            throw new RetrieveFailedException(se.getReturnCode());
        }
        catch (Exception e) {
            AuthenticationSystem.handleUnexpectedException(e);
        }
        return tkn;
    }

    public int getTimeToExpiration() throws RetrieveFailedException {
        ProgramCall programCall = new ProgramCall(this.getCredential().getSystem());
        ProgramParameter[] parmlist = new ProgramParameter[]{new ProgramParameter(4), new ProgramParameter(new AS400ByteArray(32).toBytes(((ProfileTokenCredential)this.getCredential()).getToken())), new ProgramParameter(new AS400Bin4().toBytes(0))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGETPT", "PGM"), parmlist);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGETPT failed.");
                throw new RetrieveFailedException();
            }
        }
        catch (IOException ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
        catch (InterruptedException ine) {
            AuthenticationSystem.handleUnexpectedException(ine);
        }
        catch (Exception e) {
            throw new RetrieveFailedException(programCall.getMessageList());
        }
        return new AS400Bin4().toInt(parmlist[0].getOutputData());
    }

    public byte[] refresh(int type, int timeoutInterval) throws RefreshFailedException {
        ProfileTokenCredential tgt = (ProfileTokenCredential)this.getCredential();
        AS400 sys = tgt.getSystem();
        ProgramCall programCall = new ProgramCall(tgt.getSystem());
        ProgramParameter[] parmlist = new ProgramParameter[]{new ProgramParameter(32), new ProgramParameter(new AS400ByteArray(32).toBytes(tgt.getToken())), new ProgramParameter(new AS400Bin4().toBytes(timeoutInterval)), new ProgramParameter(new AS400Text(1, sys.getCcsid(), sys).toBytes(new Integer(type).toString())), new ProgramParameter(new AS400Bin4().toBytes(0))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENFT", "PGM"), parmlist);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENFT failed.");
                throw new RefreshFailedException();
            }
        }
        catch (IOException ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
        catch (InterruptedException ine) {
            AuthenticationSystem.handleUnexpectedException(ine);
        }
        catch (Exception e) {
            throw new RefreshFailedException(programCall.getMessageList());
        }
        return (byte[])new AS400ByteArray(32).toObject(parmlist[0].getOutputData());
    }

    void removeFromSystem() throws DestroyFailedException {
        ProfileTokenCredential tgt = (ProfileTokenCredential)this.getCredential();
        AS400 sys = tgt.getSystem();
        ProgramCall programCall = new ProgramCall(sys);
        ProgramParameter[] parmlist = new ProgramParameter[]{new ProgramParameter(new AS400Text(10, sys.getCcsid(), sys).toBytes("*PRFTKN")), new ProgramParameter(new AS400Bin4().toBytes(0)), new ProgramParameter(new AS400ByteArray(32).toBytes(tgt.getToken()))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYRMVPT", "PGM"), parmlist);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYRMVPT failed.");
                throw new DestroyFailedException();
            }
        }
        catch (IOException ioe) {
            AuthenticationSystem.handleUnexpectedException(ioe);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
        catch (InterruptedException ine) {
            AuthenticationSystem.handleUnexpectedException(ine);
        }
        catch (Exception e) {
            throw new DestroyFailedException(programCall.getMessageList());
        }
    }

    private static byte[] stringToByteArray(String source) throws RetrieveFailedException {
        char[] sourceChars = source.toCharArray();
        byte[] returnBytes = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        block55: for (int i = 0; i < sourceChars.length; ++i) {
            switch (sourceChars[i]) {
                case '#': {
                    returnBytes[i] = 123;
                    continue block55;
                }
                case '$': {
                    returnBytes[i] = 91;
                    continue block55;
                }
                case '0': {
                    returnBytes[i] = -16;
                    continue block55;
                }
                case '1': {
                    returnBytes[i] = -15;
                    continue block55;
                }
                case '2': {
                    returnBytes[i] = -14;
                    continue block55;
                }
                case '3': {
                    returnBytes[i] = -13;
                    continue block55;
                }
                case '4': {
                    returnBytes[i] = -12;
                    continue block55;
                }
                case '5': {
                    returnBytes[i] = -11;
                    continue block55;
                }
                case '6': {
                    returnBytes[i] = -10;
                    continue block55;
                }
                case '7': {
                    returnBytes[i] = -9;
                    continue block55;
                }
                case '8': {
                    returnBytes[i] = -8;
                    continue block55;
                }
                case '9': {
                    returnBytes[i] = -7;
                    continue block55;
                }
                case '@': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case 'A': {
                    returnBytes[i] = -63;
                    continue block55;
                }
                case 'B': {
                    returnBytes[i] = -62;
                    continue block55;
                }
                case 'C': {
                    returnBytes[i] = -61;
                    continue block55;
                }
                case 'D': {
                    returnBytes[i] = -60;
                    continue block55;
                }
                case 'E': {
                    returnBytes[i] = -59;
                    continue block55;
                }
                case 'F': {
                    returnBytes[i] = -58;
                    continue block55;
                }
                case 'G': {
                    returnBytes[i] = -57;
                    continue block55;
                }
                case 'H': {
                    returnBytes[i] = -56;
                    continue block55;
                }
                case 'I': {
                    returnBytes[i] = -55;
                    continue block55;
                }
                case 'J': {
                    returnBytes[i] = -47;
                    continue block55;
                }
                case 'K': {
                    returnBytes[i] = -46;
                    continue block55;
                }
                case 'L': {
                    returnBytes[i] = -45;
                    continue block55;
                }
                case 'M': {
                    returnBytes[i] = -44;
                    continue block55;
                }
                case 'N': {
                    returnBytes[i] = -43;
                    continue block55;
                }
                case 'O': {
                    returnBytes[i] = -42;
                    continue block55;
                }
                case 'P': {
                    returnBytes[i] = -41;
                    continue block55;
                }
                case 'Q': {
                    returnBytes[i] = -40;
                    continue block55;
                }
                case 'R': {
                    returnBytes[i] = -39;
                    continue block55;
                }
                case 'S': {
                    returnBytes[i] = -30;
                    continue block55;
                }
                case 'T': {
                    returnBytes[i] = -29;
                    continue block55;
                }
                case 'U': {
                    returnBytes[i] = -28;
                    continue block55;
                }
                case 'V': {
                    returnBytes[i] = -27;
                    continue block55;
                }
                case 'W': {
                    returnBytes[i] = -26;
                    continue block55;
                }
                case 'X': {
                    returnBytes[i] = -25;
                    continue block55;
                }
                case 'Y': {
                    returnBytes[i] = -24;
                    continue block55;
                }
                case 'Z': {
                    returnBytes[i] = -23;
                    continue block55;
                }
                case '_': {
                    returnBytes[i] = 109;
                    continue block55;
                }
                case '\u00a3': {
                    returnBytes[i] = 123;
                    continue block55;
                }
                case '\u00a5': {
                    returnBytes[i] = 91;
                    continue block55;
                }
                case '\u00a7': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case '\u00c4': {
                    returnBytes[i] = 123;
                    continue block55;
                }
                case '\u00c5': {
                    returnBytes[i] = 91;
                    continue block55;
                }
                case '\u00c6': {
                    returnBytes[i] = 123;
                    continue block55;
                }
                case '\u00d0': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case '\u00d1': {
                    returnBytes[i] = 123;
                    continue block55;
                }
                case '\u00d6': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case '\u00d8': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case '\u00e0': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                case '\u0130': {
                    returnBytes[i] = 91;
                    continue block55;
                }
                case '\u015e': {
                    returnBytes[i] = 124;
                    continue block55;
                }
                default: {
                    throw new RetrieveFailedException(63);
                }
            }
        }
        return returnBytes;
    }
}

