/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BASE64Encoder {
    Object encoder;
    boolean sunMisc = false;
    boolean javaUtil = false;
    private Method encodeBufferMethod;
    static byte[] dummyBytes = new byte[0];

    public BASE64Encoder() {
        try {
            String sunClass = "sun.misc.BASE64Encoder";
            Class<?> encoderClass = Class.forName(sunClass);
            this.encoder = encoderClass.newInstance();
            Class[] parameterTypes = new Class[]{dummyBytes.getClass()};
            this.encodeBufferMethod = encoderClass.getMethod("encodeBuffer", parameterTypes);
            this.sunMisc = true;
        }
        catch (ClassNotFoundException e) {
            Trace.log(2, e);
        }
        catch (InstantiationException e) {
            Trace.log(2, e);
        }
        catch (IllegalAccessException e) {
            Trace.log(2, e);
        }
        catch (SecurityException e) {
            Trace.log(2, e);
        }
        catch (NoSuchMethodException e) {
            Trace.log(2, e);
        }
        if (!this.sunMisc) {
            try {
                Class<?> baseClass = Class.forName("java.util.Base64");
                Class[] zeroArgs = new Class[]{};
                Method getEncoderMethod = baseClass.getMethod("getEncoder", zeroArgs);
                this.encoder = getEncoderMethod.invoke(null, null);
                Class<?> encoderClass = this.encoder.getClass();
                Class[] parameterTypes = new Class[]{dummyBytes.getClass()};
                this.encodeBufferMethod = encoderClass.getMethod("encodeToString", parameterTypes);
                this.javaUtil = true;
            }
            catch (ClassNotFoundException e) {
                Trace.log(2, e);
            }
            catch (IllegalAccessException e) {
                Trace.log(2, e);
            }
            catch (SecurityException e) {
                Trace.log(2, e);
            }
            catch (NoSuchMethodException e) {
                Trace.log(2, e);
            }
            catch (IllegalArgumentException e) {
                Trace.log(2, e);
            }
            catch (InvocationTargetException e) {
                Trace.log(2, e);
            }
        }
    }

    public String encodeBuffer(byte[] bytes) {
        if (this.sunMisc | this.javaUtil) {
            Object[] args = new Object[]{bytes};
            try {
                return (String)this.encodeBufferMethod.invoke(this.encoder, args);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)e;
                    Throwable cause = ite.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    Error error = new Error("UNEXPECTED EXCEPTION");
                    error.initCause(e);
                    throw error;
                }
                Error error = new Error("UNEXPECTED EXCEPTION");
                error.initCause(e);
                throw error;
            }
        }
        throw new Error("UNIMPLEMENTED");
    }
}

