/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.CommTraceDisplayListener;
import com.ibm.as400.util.commtrace.Find;
import com.ibm.as400.util.commtrace.Format;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

class FormatDisplay
extends WindowAdapter
implements Runnable {
    private final String ALL = "*ALL";
    private final String YES = "*YES";
    private final String NO = "*NO";
    private final String CLASS = "FormatDisplay";
    private AS400 sys;
    private Thread fmtThread = null;
    private Format fmt = null;
    private Find find = null;
    private String filterIPaddr_;
    private String filterIPaddr2_;
    private String filterPort_;
    private String filterBdcst_;
    private String currPage = "";
    private String lastPage = "";
    private String slastPage = "";
    private String path = null;
    private String file = null;
    private String filename = null;
    private String outfile = null;
    private int nextRecLen = 0;
    private int index = 0;
    public static final int OPEN = 1;
    public static final int OPENRMT = 2;
    public static final int FMT = 3;
    private static final String SAVEEXT = ".bin";
    private int ifsrecs = 0;
    private int recsdisp = 0;
    private int page = 0;
    private int oper;
    private JMenuItem fsave;
    private JMenuItem fclose;
    private JMenuItem ffind;
    private JMenuItem fcopy;
    private JMenuItem fclear;
    private JMenuItem fcut;
    private JMenuItem fpaste;
    private JButton next;
    private JButton prev;
    private JComboBox numberList_;
    private JLabel msg;
    private JTextArea formattrace;
    private JFrame l;

    public FormatDisplay(String filterIPaddr, String filterIPaddr2, String filterPort, String filterBdcst, int oper) {
        this.filterIPaddr_ = filterIPaddr;
        this.filterIPaddr2_ = filterIPaddr2;
        this.filterPort_ = filterPort;
        this.filterBdcst_ = filterBdcst;
        this.oper = oper;
        if (oper == 3) {
            FileDialog fd = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("FormatDialog"), 0);
            fd.show();
            String path = fd.getDirectory();
            this.filename = fd.getFile();
            if (path == null || this.filename == null) {
                return;
            }
            this.filename = path + this.filename;
        } else if (oper == 1 || oper == 2) {
            this.open();
        }
    }

    public FormatDisplay(String path, String file, AS400 sys, int oper) {
        this.oper = oper;
        this.sys = sys;
        this.path = path;
        this.file = file;
        if (oper == 2 || oper == 1) {
            this.open();
        }
    }

    public void run() {
        boolean fmt = true;
        Thread myThread = Thread.currentThread();
        while (this.fmtThread == myThread) {
            if (fmt) {
                if (this.oper == 3) {
                    if (this.filename == null) {
                        return;
                    }
                    FileDialog fd = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("SaveAs"), 1);
                    fd.setFile(this.filename + SAVEEXT);
                    fd.show();
                    String outpath = fd.getDirectory();
                    String outfilename = fd.getFile();
                    if (outfilename == null) {
                        return;
                    }
                    this.outfile = outpath + outfilename;
                    FormatProperties prop = new FormatProperties();
                    prop.setProgress("True");
                    if (!this.filterIPaddr_.equals("*ALL")) {
                        prop.setIPAddress(this.filterIPaddr_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on IP address");
                        }
                    }
                    if (!this.filterIPaddr2_.equals("*ALL")) {
                        prop.setSecondIPAddress(this.filterIPaddr2_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on IP address");
                        }
                    }
                    if (!this.filterPort_.equals("*ALL")) {
                        prop.setPort(this.filterPort_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on port number");
                        }
                    }
                    if (this.filterBdcst_.equals("*NO")) {
                        prop.setBroadcast(this.filterBdcst_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering broadcast records");
                        }
                    }
                    this.fmt = new Format(prop, this.outfile, this.filename);
                    long strtime = System.currentTimeMillis();
                    this.fmt.toLclBinFile();
                    long endtime = System.currentTimeMillis();
                    if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                        Trace.log(3, "FormatDisplay.run() Format Start/End/Total Time:" + strtime + "/" + endtime + "/" + (endtime - strtime));
                    }
                    this.fmt.openLclFile();
                    this.showOutput();
                    fmt = false;
                    continue;
                }
                if (this.oper != 1 && this.oper != 2) continue;
                this.showOutput();
                fmt = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fmt.close();
    }

    private void showOutput() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "FormatDisplay.showOutput() Showing Output");
        }
        this.l = new JFrame("Comm Trace");
        this.formattrace = new JTextArea("", 10, 80);
        JMenuBar formatmb = new JMenuBar();
        JMenu ffile = new JMenu(ResourceBundleLoader_ct.getText("File"));
        JMenu fedit = new JMenu(ResourceBundleLoader_ct.getText("Edit"));
        JScrollPane p = new JScrollPane(this.formattrace);
        JPanel north = new JPanel();
        north.setLayout(new GridLayout(0, 1));
        JPanel nav = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        nav.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.gridwidth = 3;
        c.gridheight = 3;
        JLabel lshow = new JLabel(ResourceBundleLoader_ct.getText("Show"));
        gridbag.setConstraints(lshow, c);
        nav.add(lshow);
        c.anchor = 10;
        c.gridwidth = -1;
        String[] numberStrings = new String[]{"10", "50", "100", "1000", "10000"};
        this.numberList_ = new JComboBox<String>(numberStrings);
        this.numberList_.setSelectedIndex(2);
        gridbag.setConstraints(this.numberList_, c);
        nav.add(this.numberList_);
        c.anchor = 10;
        c.gridwidth = 0;
        JLabel lframes = new JLabel(ResourceBundleLoader_ct.getText("ShowDescription"));
        gridbag.setConstraints(lframes, c);
        nav.add(lframes);
        c.anchor = 17;
        c.gridwidth = -1;
        c.gridheight = -1;
        JLabel msgdesc = new JLabel(ResourceBundleLoader_ct.getText("DisplayDescription"));
        gridbag.setConstraints(msgdesc, c);
        nav.add(msgdesc);
        c.gridwidth = 0;
        this.msg = new JLabel(ResourceBundleLoader_ct.getText("Prolog"));
        gridbag.setConstraints(this.msg, c);
        nav.add(this.msg);
        c.anchor = 10;
        c.gridwidth = -1;
        c.gridheight = 0;
        this.prev = new JButton(ResourceBundleLoader_ct.getText("Prev"));
        this.prev.addActionListener(new CommTraceDisplayListener(this));
        gridbag.setConstraints(this.prev, c);
        nav.add(this.prev);
        c.anchor = 17;
        c.gridwidth = 0;
        this.next = new JButton(ResourceBundleLoader_ct.getText("Next"));
        this.next.addActionListener(new CommTraceDisplayListener(this));
        gridbag.setConstraints(this.next, c);
        nav.add(this.next);
        north.add(nav);
        String record = ResourceBundleLoader_ct.getText("Record");
        String mac = ResourceBundleLoader_ct.getText("MACAddress");
        StringBuffer Banner1 = new StringBuffer();
        Banner1.append(record);
        Banner1.append("       ");
        Banner1.append(ResourceBundleLoader_ct.getText("Data"));
        Banner1.append("      ");
        Banner1.append(record);
        Banner1.append("                     ");
        Banner1.append(ResourceBundleLoader_ct.getText("Destination"));
        Banner1.append("     ");
        Banner1.append(ResourceBundleLoader_ct.getText("Source"));
        Banner1.append("           ");
        Banner1.append(ResourceBundleLoader_ct.getText("Frame"));
        StringBuffer Banner2 = new StringBuffer();
        Banner2.append(ResourceBundleLoader_ct.getText("Number"));
        Banner2.append("  ");
        Banner2.append(ResourceBundleLoader_ct.getText("S/R"));
        Banner2.append("  ");
        Banner2.append(ResourceBundleLoader_ct.getText("Length"));
        Banner2.append("    ");
        Banner2.append(ResourceBundleLoader_ct.getText("Timer"));
        Banner2.append("                      ");
        Banner2.append(mac);
        Banner2.append("     ");
        Banner2.append(mac);
        Banner2.append("      ");
        Banner2.append(ResourceBundleLoader_ct.getText("Format"));
        String Banner3 = "------  ---  ------    ------------               --------------  --------------   ------";
        JPanel ban = new JPanel();
        ban.setLayout(new GridLayout(3, 1));
        JLabel banner = new JLabel(Banner1.toString());
        JLabel banner2 = new JLabel(Banner2.toString());
        JLabel banner3 = new JLabel(Banner3);
        banner.setFont(new Font("Monospaced", 0, 12));
        banner2.setFont(new Font("Monospaced", 0, 12));
        banner3.setFont(new Font("Monospaced", 0, 12));
        ban.add(banner);
        ban.add(banner2);
        ban.add(banner3);
        this.fsave = new JMenuItem(ResourceBundleLoader_ct.getText("Save"), 83);
        this.fsave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        if (this.oper == 1 || this.oper == 2) {
            this.fsave.setEnabled(false);
        }
        this.fclose = new JMenuItem(ResourceBundleLoader_ct.getText("Close"), 87);
        this.fclose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.ffind = new JMenuItem(ResourceBundleLoader_ct.getText("Find"), 70);
        this.ffind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fcopy = new JMenuItem(ResourceBundleLoader_ct.getText("Copy"), 67);
        this.fcopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.fclear = new JMenuItem(ResourceBundleLoader_ct.getText("Clear"));
        this.fcut = new JMenuItem(ResourceBundleLoader_ct.getText("Cut"), 88);
        this.fcut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.fpaste = new JMenuItem(ResourceBundleLoader_ct.getText("Paste"), 86);
        this.fpaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        ffile.add(this.fsave);
        this.fsave.addActionListener(new CommTraceDisplayListener(this));
        ffile.add(this.fclose);
        this.fclose.addActionListener(new CommTraceDisplayListener(this));
        fedit.add(this.ffind);
        this.ffind.addActionListener(new CommTraceDisplayListener(this));
        fedit.add(this.fcopy);
        this.fcopy.addActionListener(new CommTraceDisplayListener(this));
        fedit.add(this.fclear);
        this.fclear.addActionListener(new CommTraceDisplayListener(this));
        fedit.add(this.fcut);
        this.fcut.addActionListener(new CommTraceDisplayListener(this));
        fedit.add(this.fpaste);
        this.fpaste.addActionListener(new CommTraceDisplayListener(this));
        this.fcut.setEnabled(false);
        this.fpaste.setEnabled(false);
        formatmb.add(ffile);
        formatmb.add(fedit);
        this.l.setJMenuBar(formatmb);
        this.formattrace.enableInputMethods(true);
        this.formattrace.setFont(new Font("Monospaced", 0, 12));
        if (this.fmt == null) {
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(2, "FormatDisplay.showOutput() initialization failed");
            }
            return;
        }
        this.showRecs(1);
        this.msg.setText("Prolog");
        this.recsdisp = 0;
        this.ifsrecs = this.fmt.getIntFromFile();
        this.l.getContentPane().add((Component)p, "Center");
        this.l.getContentPane().add((Component)north, "South");
        this.l.getContentPane().add((Component)ban, "North");
        this.l.setBackground(Color.black);
        this.l.setForeground(Color.white);
        this.l.addWindowListener(this);
        this.l.setSize(800, 600);
        this.l.setVisible(true);
    }

    public boolean showRecs(int numrecs) {
        int tcprecs = this.fmt.getNumberOfTCPRecords();
        ((Component)this.l).setCursor(new Cursor(3));
        if (this.page == 0) {
            if (this.oper == 1 || this.oper == 2) {
                int end = this.recsdisp + numrecs;
                if (end > this.ifsrecs) {
                    this.msg.setText(this.recsdisp + "-" + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                } else {
                    this.msg.setText(this.recsdisp + "-" + (this.recsdisp + numrecs) + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                }
                this.recsdisp = end;
                if (this.lastPage.equals("")) {
                    this.lastPage = this.formattrace.getText();
                } else {
                    this.slastPage = this.lastPage;
                    this.lastPage = this.formattrace.getText();
                }
                this.formattrace.setText(null);
                for (int i = 0; i < numrecs; ++i) {
                    String rec = null;
                    rec = this.fmt.getRecFromFile();
                    if (rec == null) {
                        ((Component)this.l).setCursor(new Cursor(0));
                        return false;
                    }
                    this.formattrace.append(rec);
                }
            } else {
                int end = this.recsdisp + numrecs;
                if (end > tcprecs) {
                    this.msg.setText(this.recsdisp + "-" + tcprecs + " " + ResourceBundleLoader_ct.getText("of") + " " + tcprecs);
                } else {
                    this.msg.setText(this.recsdisp + "-" + end + " " + ResourceBundleLoader_ct.getText("of") + " " + tcprecs);
                }
                this.recsdisp = end;
                if (this.lastPage.equals("")) {
                    this.lastPage = this.formattrace.getText();
                } else {
                    this.slastPage = this.lastPage;
                    this.lastPage = this.formattrace.getText();
                }
                this.formattrace.setText(null);
                for (int i = 0; i < numrecs; ++i) {
                    String rec = null;
                    rec = this.fmt.getRecFromFile();
                    if (rec == null) {
                        ((Component)this.l).setCursor(new Cursor(0));
                        return false;
                    }
                    this.formattrace.append(rec);
                }
            }
        } else if (this.page == 1) {
            this.formattrace.setText(this.currPage);
            if (tcprecs == 0) {
                if (this.recsdisp > this.ifsrecs) {
                    this.msg.setText(this.recsdisp + "-" + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                } else {
                    this.msg.setText(this.recsdisp - numrecs + "-" + this.recsdisp + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                }
                if (this.recsdisp >= this.ifsrecs) {
                    ((Component)this.l).setCursor(new Cursor(0));
                    this.page = 0;
                    return false;
                }
            } else {
                if (this.recsdisp > tcprecs) {
                    this.msg.setText(this.recsdisp + "-" + tcprecs + " " + ResourceBundleLoader_ct.getText("of") + " " + tcprecs);
                } else {
                    this.msg.setText(this.recsdisp - numrecs + "-" + this.recsdisp + " " + ResourceBundleLoader_ct.getText("of") + " " + tcprecs);
                }
                if (this.recsdisp >= tcprecs) {
                    ((Component)this.l).setCursor(new Cursor(0));
                    this.page = 0;
                    return false;
                }
            }
            this.page = 0;
        } else if (this.page == 2) {
            this.formattrace.setText(this.lastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage"));
            this.page = 1;
        }
        ((Component)this.l).setCursor(new Cursor(0));
        return true;
    }

    public void showPrev() {
        if (this.page == 0) {
            this.currPage = this.formattrace.getText();
            this.formattrace.setText(this.lastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage"));
            this.page = 1;
        } else if (this.page == 1) {
            this.formattrace.setText(this.slastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage") + " 2");
            this.page = 2;
        } else if (this.page == 2) {
            CommTrace.error(this.l, "Not Found", "Only the two previous pages are stored");
        }
    }

    public void open() {
        if (this.oper == 1) {
            FileDialog fd = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("OpenDialog"), 0);
            fd.show();
            String path = fd.getDirectory();
            String file = fd.getFile();
            if (path == null || file == null) {
                return;
            }
            this.fmt = new Format();
            this.fmt.openLclFile(path + file);
            this.outfile = path + file;
        } else if (this.oper == 2) {
            if (this.path != "" && this.file != "") {
                this.fmt = new Format(this.sys);
                this.fmt.openIFSFile(this.path + "/" + this.file + SAVEEXT);
            } else {
                IFSFileDialog fd = new IFSFileDialog((Frame)new JFrame(), ResourceBundleLoader_ct.getText("FiletoView"), this.sys);
                FileFilter[] filterList = new FileFilter[]{new FileFilter(ResourceBundleLoader_ct.getText("AllFiles"), "*.*"), new FileFilter(ResourceBundleLoader_ct.getText("CommTraceFiles"), "*.bin")};
                fd.setFileFilter(filterList, 0);
                fd.setDirectory(this.path);
                fd.setFileName(this.file);
                String fullpath = "";
                if (fd.showDialog() == 1) {
                    fullpath = fd.getAbsolutePath();
                    this.fmt = new Format(this.sys);
                    this.fmt.openIFSFile(fullpath);
                }
            }
        }
    }

    public boolean save() {
        BufferedWriter out;
        String file;
        FileDialog fd = new FileDialog((Frame)this.l, ResourceBundleLoader_ct.getText("SaveAs"), 1);
        if (this.filename == null) {
            file = this.outfile;
            int index = this.outfile.indexOf(46);
            if (index != -1) {
                file = this.outfile.substring(0, index);
            }
            fd.setFile(file + ".txt");
        } else {
            fd.setFile(this.filename + ".txt");
        }
        fd.show();
        String path = fd.getDirectory();
        file = fd.getFile();
        ((Component)this.l).setCursor(new Cursor(3));
        try {
            out = new BufferedWriter(new FileWriter(path + file));
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error opening " + path + file, (Throwable)e);
            }
            return false;
        }
        try {
            String rec;
            Format fmtlcl = new Format();
            fmtlcl.openLclFile(this.outfile);
            String prolog = fmtlcl.getRecFromFile();
            out.write(prolog);
            int numrecs = fmtlcl.getIntFromFile();
            int recPrinted = 0;
            while ((rec = fmtlcl.getRecFromFile()) != null) {
                if (recPrinted % 5 == 0) {
                    out.write(this.fmt.addBanner());
                }
                out.write(rec);
                ++recPrinted;
            }
            fmtlcl.close();
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error writing to " + path + file, (Throwable)e);
            }
            return false;
        }
        try {
            ((Writer)out).close();
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error closing " + path + file, (Throwable)e);
            }
            return false;
        }
        ((Component)this.l).setCursor(new Cursor(0));
        return true;
    }

    private String addEndBanner() {
        return "\n* * * * * * * * * * * * *    " + ResourceBundleLoader_ct.getText("EOCP") + "    * * * * * * * * * * * * *\n";
    }

    public void close() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "FormatDisplay.close()");
        }
        if (this.l != null) {
            this.l.setVisible(false);
        }
        if (this.fmt != null) {
            this.fmt.close();
        }
        this.fmtThread = null;
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.l) {
            this.close();
        }
    }

    public void find() {
        if (this.find == null || this.find.isClosed()) {
            this.find = new Find(this.formattrace);
        } else {
            this.find.toFront();
        }
    }

    public void copy() {
        this.formattrace.copy();
    }

    public void clear() {
        this.formattrace.setText("");
    }

    public void cut() {
        this.formattrace.cut();
    }

    public void paste() {
        this.formattrace.paste();
    }

    public Thread getThread() {
        return this.fmtThread;
    }

    public void setThread(Thread tr) {
        this.fmtThread = tr;
    }

    public JComboBox getNumberList() {
        return this.numberList_;
    }

    public JMenuItem getSaveMenuItem() {
        return this.fsave;
    }

    public JMenuItem getCloseMenuItem() {
        return this.fclose;
    }

    public JMenuItem getFindMenuItem() {
        return this.ffind;
    }

    public JMenuItem getCopyMenuItem() {
        return this.fcopy;
    }

    public JMenuItem getClearMenuItem() {
        return this.fclear;
    }

    public JMenuItem getCutMenuItem() {
        return this.fcut;
    }

    public JMenuItem getPasteMenuItem() {
        return this.fpaste;
    }

    public JButton getNextButton() {
        return this.next;
    }

    public JButton getPrevButton() {
        return this.prev;
    }

    public JFrame getDisplayFrame() {
        return this.l;
    }
}

