/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;

public class ICMP4Header
extends Header {
    Field typefield;
    Field code;
    Field checksum;
    private static final String CLASS = "ICMP4Header";
    private static final String ECHRPLY = "Echo Reply";
    private static final String DSTURCH = "Destination Unreachable";
    private static final String SRCQCH = "Source Quench";
    private static final String RDR = "Redirect (Change a Route)";
    private static final String ECHREQ = "Echo Request";
    private static final String TIMEEXC = "Time Exceeded for a Datagram";
    private static final String PARAMPROB = "Parameter Problem on a Datagram";
    private static final String TSTMPREQ = "Timestamp Request";
    private static final String TSTMPRPLY = "Timestamp Reply";
    private static final String INFOREQ = "Information Request (Obsolete)";
    private static final String INFORPLY = "Information Reply (Obsolete)";
    private static final String ADDRREQ = "Address Mask Request";
    private static final String ADDRRPLY = "Address Mask Reply";
    private static final String ICMP = "ICMPv4 Header";
    private static final String TYPE = "Type";
    private static final String CODE = "Code";
    private static final String CHKSUM = "Checksum";

    ICMP4Header(BitBuf data) {
        super(data);
        this.typefield = new Dec(this.rawheader.slice(0, 8));
        this.code = new Hex(this.rawheader.slice(8, 8));
        this.checksum = new Hex(this.rawheader.slice(16, 16));
        this.type = 1;
    }

    public int getHeaderLen() {
        return 32;
    }

    public String toString(FormatProperties filter) {
        String types = "";
        int type = Integer.parseInt(this.typefield.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (filter != null) {
            boolean print = false;
            String port = filter.getPort();
            if (port == null) {
                print = true;
            }
            if (!print) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "ICMP4Header.toString() Frame doesn't pass IP filter");
                }
                return "";
            }
        }
        if (type == 0) {
            types = ECHRPLY;
        } else if (type == 3) {
            types = DSTURCH;
        } else if (type == 4) {
            types = SRCQCH;
        } else if (type == 5) {
            types = RDR;
        } else if (type == 8) {
            types = ECHREQ;
        } else if (type == 11) {
            types = TIMEEXC;
        } else if (type == 12) {
            types = PARAMPROB;
        } else if (type == 13) {
            types = TSTMPREQ;
        } else if (type == 14) {
            types = TSTMPRPLY;
        } else if (type == 15) {
            types = INFOREQ;
        } else if (type == 16) {
            types = INFORPLY;
        } else if (type == 17) {
            types = ADDRREQ;
        } else if (type == 18) {
            types = ADDRRPLY;
        }
        Object[] args = new Object[]{types, this.code, this.checksum};
        return Formatter.jsprintf("\t    ICMPv4 Header : Type: {0}     Code: {1}     Checksum: {2}\n", args) + this.printHexHeader() + this.printnext(filter) + new Data(this.rawpayload).toString();
    }

    public String getTypeField() {
        return this.typefield.toString();
    }

    public String getCode() {
        return new Dec(this.code.getData()).toString();
    }

    public String getChecksum() {
        return new Dec(this.checksum.getData()).toString();
    }
}

