/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VOutput;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class OutputPropertiesPane
implements VPropertiesPane,
ItemListener,
ActionListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VOutput object_;
    private SpooledFile splF_;
    private boolean functionSupported_;
    private JTextField userData_;
    private JComboBox saveBox_;
    private JTextField printer_;
    private JTextField outQ_;
    private JTextField outQLib_;
    private JComboBox outQPtyBox_;
    private JTextField totalCopies_;
    private JTextField copiesLeft_;
    private JTextField formType_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private static Calendar calendar_ = AS400Calendar.getGregorianInstance();
    private static final int supportedVRM_ = 262400;
    private static final String noText_ = ResourceLoader.getPrintText("NO");
    private static final String yesText_ = ResourceLoader.getPrintText("YES");
    private static final String jobValueText_ = ResourceLoader.getPrintText("JOB_VALUE");
    private static final String standardText_ = ResourceLoader.getPrintText("STANDARD");
    private static final String outputNameText_ = ResourceLoader.getPrintText("OUTPUT_NAME") + ":";
    private static final String numberText_ = ResourceLoader.getPrintText("NUMBER") + ":";
    private static final String statusText_ = ResourceLoader.getPrintText("STATUS") + ":";
    private static final String statusClosedText_ = ResourceLoader.getPrintText("CLOSED");
    private static final String statusHeldText_ = ResourceLoader.getPrintText("HELD");
    private static final String statusMsgWaitingText_ = ResourceLoader.getPrintText("MESSAGE_WAITING");
    private static final String statusOpenText_ = ResourceLoader.getPrintText("OPEN");
    private static final String statusPendingText_ = ResourceLoader.getPrintText("PENDING");
    private static final String statusPrinterText_ = ResourceLoader.getPrintText("PRINTER");
    private static final String statusReadyText_ = ResourceLoader.getPrintText("READY");
    private static final String statusSavedText_ = ResourceLoader.getPrintText("SAVED");
    private static final String statusWritingText_ = ResourceLoader.getPrintText("WRITING");
    private static final String userSpecDataText_ = ResourceLoader.getPrintText("USER_SPEC_DATA") + ":";
    private static final String saveText_ = ResourceLoader.getPrintText("SAVE_AFTER_PRINTING") + ":";
    private static final String printerText_ = ResourceLoader.getPrintText("PRINTER") + ":";
    private static final String outQText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE") + ":";
    private static final String outQLibText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE_LIB") + ":";
    private static final String outQPtyText_ = ResourceLoader.getPrintText("OUTQ_PRIORITY_1_9") + ":";
    private static final String totalCopiesText_ = ResourceLoader.getPrintText("TOTAL_COPIES_1_255") + ":";
    private static final String copiesLeftText_ = ResourceLoader.getPrintText("COPIES_LEFT_1_255") + ":";
    private static final String pagesPerCopyText_ = ResourceLoader.getPrintText("PAGES_PER_COPY") + ":";
    private static final String currentPageText_ = ResourceLoader.getPrintText("CURRENT_PAGE") + ":";
    private static final String lastPageText_ = ResourceLoader.getPrintText("LAST_PAGE") + ":";
    private static final String formTypeText_ = ResourceLoader.getPrintText("FORM_TYPE") + ":";
    private static final String dateText_ = ResourceLoader.getPrintText("DATE_CREATED") + ":";
    private static final String jobText_ = ResourceLoader.getPrintText("JOB") + ":";
    private static final String userText_ = ResourceLoader.getPrintText("USER") + ":";
    private static final String jobNumberText_ = ResourceLoader.getPrintText("JOB_NUMBER") + ":";
    private static final String generalText_ = ResourceLoader.getPrintText("GENERAL");
    private static final String printerQueText_ = ResourceLoader.getPrintText("PRINTERQUEUE");
    private static final String copiesText_ = ResourceLoader.getPrintText("COPIES");
    private static final String pagesText_ = ResourceLoader.getPrintText("PAGES");
    private static final String formsText_ = ResourceLoader.getPrintText("FORMS");
    private static final String originText_ = ResourceLoader.getPrintText("ORIGIN");
    private static final String userCommentText_ = ResourceLoader.getPrintText("USER_COMMENT") + ":";
    private static final String notAssignedText_ = ResourceLoader.getPrintText("NOT_ASSIGNED");
    private static final String groupText_ = ResourceLoader.getPrintText("GROUP");

    public OutputPropertiesPane(VOutput object, SpooledFile splF) {
        this.object_ = object;
        this.splF_ = splF;
        try {
            int systemVRM = this.splF_.getSystem().getVRM();
            this.functionSupported_ = systemVRM >= 262400;
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.functionSupported_ = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.changeEventSupport_.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
        String newCopiesLeft;
        String oldCopiesLeft;
        String newTotalCopies;
        String oldTotalCopies;
        String newUserData;
        PrintParameterList pList_ = new PrintParameterList();
        String oldUserData = this.splF_.getStringAttribute(116).trim();
        if (!oldUserData.equals(newUserData = this.userData_.getText().trim())) {
            pList_.setParameter(116, newUserData);
        }
        String oldSaveData = this.splF_.getStringAttribute(100);
        String newSaveData = (String)this.saveBox_.getSelectedItem();
        if (newSaveData.equals(noText_)) {
            newSaveData = "*NO";
        } else if (newSaveData.equals(yesText_)) {
            newSaveData = "*YES";
        }
        if (!oldSaveData.equals(newSaveData)) {
            pList_.setParameter(100, newSaveData);
        }
        if (this.functionSupported_) {
            String newOutQLib;
            String oldOutQLib;
            String oldPrinter = this.splF_.getStringAttribute(89).trim();
            String newPrinter = this.printer_.getText().trim();
            if (!newPrinter.equals(notAssignedText_) && !oldPrinter.equals(newPrinter)) {
                pList_.setParameter(89, newPrinter);
            }
            QSYSObjectPathName outQPath = new QSYSObjectPathName(this.splF_.getStringAttribute(-6));
            String oldOutQ = outQPath.getObjectName().trim();
            String newOutQ = this.outQ_.getText().trim();
            boolean fNewOutQ = false;
            if (!oldOutQ.equals(newOutQ)) {
                QSYSObjectPathName newOutQPath = new QSYSObjectPathName(outQPath.getLibraryName(), newOutQ, "OUTQ");
                pList_.setParameter(-6, newOutQPath.getPath());
                fNewOutQ = true;
            }
            if (!(oldOutQLib = outQPath.getLibraryName().trim()).equals(newOutQLib = this.outQLib_.getText().trim())) {
                QSYSObjectPathName newOutQPath = fNewOutQ ? new QSYSObjectPathName(newOutQLib, newOutQ, "OUTQ") : new QSYSObjectPathName(newOutQLib, oldOutQ, "OUTQ");
                pList_.setParameter(-6, newOutQPath.getPath());
            }
        }
        String oldOutQPty = this.splF_.getStringAttribute(72);
        String newOutQPty = (String)this.outQPtyBox_.getSelectedItem();
        if (newOutQPty.equals(jobValueText_)) {
            newOutQPty = "*JOB";
        }
        if (!oldOutQPty.equals(newOutQPty)) {
            pList_.setParameter(72, newOutQPty);
        }
        if (!(oldTotalCopies = this.splF_.getIntegerAttribute(28).toString()).equals(newTotalCopies = this.totalCopies_.getText().trim())) {
            pList_.setParameter(28, Integer.parseInt(newTotalCopies));
        }
        if (!(oldCopiesLeft = this.splF_.getIntegerAttribute(29).toString()).equals(newCopiesLeft = this.copiesLeft_.getText().trim())) {
            pList_.setParameter(29, Integer.parseInt(newCopiesLeft));
        }
        String oldFormType = this.splF_.getStringAttribute(48).trim();
        String newFormType = this.formType_.getText().trim();
        if (newFormType.equals(standardText_)) {
            newFormType = "*STD";
        }
        if (!oldFormType.equals(newFormType)) {
            pList_.setParameter(48, newFormType);
        }
        this.workingEventSupport_.fireStartWorking();
        this.splF_.setAttributes(pList_);
        this.workingEventSupport_.fireStopWorking();
        this.objectEventSupport_.fireObjectChanged(this.object_);
    }

    private JPanel buildCopiesPane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(totalCopiesText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            this.totalCopies_ = new JTextField(this.splF_.getIntegerAttribute(28).toString());
            this.totalCopies_.addActionListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.totalCopies_, thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(copiesLeftText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            this.copiesLeft_ = new JTextField(this.splF_.getIntegerAttribute(29).toString());
            this.copiesLeft_.addActionListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.copiesLeft_, thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    private JPanel buildGeneralPane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outputNameText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getName()), thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(numberText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(Integer.toString(this.splF_.getNumber())), thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(statusText_), thePane, layout, constraints, 0, 1, 1, 2, 1, 1, 2, 17);
            String status = this.splF_.getStringAttribute(106);
            String stat = null;
            stat = status.trim().equals("*CLOSED") ? statusClosedText_ : (status.trim().equals("*HELD") ? statusHeldText_ : (status.trim().equals("*MESSAGE") ? statusMsgWaitingText_ : (status.trim().equals("*OPEN") ? statusOpenText_ : (status.trim().equals("*PENDING") ? statusPendingText_ : (status.trim().equals("*PRINTER") ? statusPrinterText_ : (status.trim().equals("*READY") ? statusReadyText_ : (status.trim().equals("*SAVED") ? statusSavedText_ : (status.trim().equals("*WRITING") ? statusWritingText_ : " "))))))));
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(stat), thePane, layout, constraints, 1, 1, 1, 2, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(userSpecDataText_), thePane, layout, constraints, 0, 1, 1, 3, 1, 1, 2, 17);
            this.userData_ = new JTextField(this.splF_.getStringAttribute(116));
            this.userData_.addActionListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.userData_, thePane, layout, constraints, 1, 1, 1, 3, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(userCommentText_), thePane, layout, constraints, 0, 1, 1, 4, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getStringAttribute(115).trim()), thePane, layout, constraints, 1, 1, 1, 4, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(saveText_), thePane, layout, constraints, 0, 1, 1, 5, 1, 1, 2, 17);
            this.saveBox_ = new JComboBox();
            this.saveBox_.addItem(yesText_);
            this.saveBox_.addItem(noText_);
            String curSave = this.splF_.getStringAttribute(100).trim();
            if (curSave.equals("*NO")) {
                this.saveBox_.setSelectedItem(noText_);
            } else if (curSave.equals("*YES")) {
                this.saveBox_.setSelectedItem(yesText_);
            } else {
                this.saveBox_.setSelectedItem(curSave);
            }
            this.saveBox_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.saveBox_, thePane, layout, constraints, 1, 1, 1, 5, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    private JPanel buildFormsPane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(formTypeText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            String formType = this.splF_.getStringAttribute(48).trim();
            this.formType_ = formType.equals("*STD") ? new JTextField(standardText_) : new JTextField(formType);
            this.formType_.addActionListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.formType_, thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    private JPanel buildOriginPane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            String date = this.splF_.getStringAttribute(34);
            String time = this.splF_.getStringAttribute(110);
            calendar_.set(Integer.parseInt(date.substring(0, 3)) + 1900, Integer.parseInt(date.substring(3, 5)) - 1, Integer.parseInt(date.substring(5, 7)), Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(2, 4)), Integer.parseInt(time.substring(4, 6)));
            Date newDate = calendar_.getTime();
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(dateText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(dateFormat_.format(newDate)), thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(jobText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getStringAttribute(59)), thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel("  " + userText_), thePane, layout, constraints, 0, 1, 1, 2, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getStringAttribute(62)), thePane, layout, constraints, 1, 1, 1, 2, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel("  " + jobNumberText_), thePane, layout, constraints, 0, 1, 1, 3, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getStringAttribute(60)), thePane, layout, constraints, 1, 1, 1, 3, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    private JPanel buildPagesPane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(pagesPerCopyText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getIntegerAttribute(111).toString()), thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(currentPageText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getIntegerAttribute(30).toString()), thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(lastPageText_), thePane, layout, constraints, 0, 1, 1, 2, 1, 1, 2, 17);
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(this.splF_.getIntegerAttribute(63).toString()), thePane, layout, constraints, 1, 1, 1, 2, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    private JPanel buildPrinterQueuePane() {
        JPanel thePane = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        thePane.setLayout(layout);
        thePane.setBorder(new EmptyBorder(10, 10, 10, 10));
        QSYSObjectPathName outQPath = new QSYSObjectPathName();
        try {
            GridBagConstraints constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(printerText_), thePane, layout, constraints, 0, 1, 1, 0, 1, 1, 2, 17);
            if (this.functionSupported_) {
                String printer = this.splF_.getStringAttribute(89).trim();
                String prtAssigned = this.splF_.getStringAttribute(186).trim();
                this.printer_ = prtAssigned.equals("3") ? new JTextField(notAssignedText_) : (prtAssigned.equals("2") ? new JTextField(groupText_) : new JTextField(printer));
                this.printer_.addActionListener(this);
                constraints = new GridBagConstraints();
                VUtilities.constrain(this.printer_, thePane, layout, constraints, 1, 1, 1, 0, 1, 1, 2, 17);
            }
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outQText_), thePane, layout, constraints, 0, 1, 1, 1, 1, 1, 2, 17);
            if (this.functionSupported_) {
                outQPath.setPath(this.splF_.getStringAttribute(-6));
                this.outQ_ = new JTextField(outQPath.getObjectName());
                this.outQ_.addActionListener(this);
                constraints = new GridBagConstraints();
                VUtilities.constrain(this.outQ_, thePane, layout, constraints, 1, 1, 1, 1, 1, 1, 2, 17);
            }
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outQLibText_), thePane, layout, constraints, 0, 1, 1, 2, 1, 1, 2, 17);
            if (this.functionSupported_) {
                this.outQLib_ = new JTextField(outQPath.getLibraryName());
                this.outQLib_.addActionListener(this);
                constraints = new GridBagConstraints();
                VUtilities.constrain(this.outQLib_, thePane, layout, constraints, 1, 1, 1, 2, 1, 1, 2, 17);
            }
            constraints = new GridBagConstraints();
            VUtilities.constrain(new JLabel(outQPtyText_), thePane, layout, constraints, 0, 1, 1, 3, 1, 1, 2, 17);
            this.outQPtyBox_ = new JComboBox();
            this.outQPtyBox_.setEditable(true);
            String outqPty = this.splF_.getStringAttribute(72).trim();
            this.outQPtyBox_.addItem(jobValueText_);
            if (outqPty.equals("*JOB")) {
                this.outQPtyBox_.setSelectedItem(jobValueText_);
            } else {
                this.outQPtyBox_.addItem(outqPty);
                this.outQPtyBox_.setSelectedItem(outqPty);
            }
            this.outQPtyBox_.addItemListener(this);
            constraints = new GridBagConstraints();
            VUtilities.constrain(this.outQPtyBox_, thePane, layout, constraints, 1, 1, 1, 3, 1, 1, 2, 17);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return thePane;
    }

    public Component getComponent() {
        JTabbedPane tabbedPane = null;
        tabbedPane = new JTabbedPane();
        tabbedPane.addTab(generalText_, null, this.buildGeneralPane());
        tabbedPane.setSelectedIndex(0);
        tabbedPane.addTab(printerQueText_, null, this.buildPrinterQueuePane());
        tabbedPane.addTab(copiesText_, null, this.buildCopiesPane());
        tabbedPane.addTab(pagesText_, null, this.buildPagesPane());
        tabbedPane.addTab(formsText_, null, this.buildFormsPane());
        tabbedPane.addTab(originText_, null, this.buildOriginPane());
        return tabbedPane;
    }

    public void itemStateChanged(ItemEvent e) {
        this.changeEventSupport_.fireStateChanged();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }
}

