/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;

class PermissionAction
implements VAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean enabled_ = true;
    private IFSFile file_;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public PermissionAction(IFSFile file) {
        this.file_ = file;
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    Permission getPermission() {
        try {
            return new Permission(this.file_);
        }
        catch (Exception e) {
            Trace.log(2, "construct Permission : " + e);
            this.errorEventSupport_.fireError(e);
            return null;
        }
    }

    public String getText() {
        return ResourceLoader.getText("OBJECT_PERMISSION2");
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext vAction) {
        this.workingEventSupport_.fireStartWorking();
        PermissionMainPanel mainPanel = new PermissionMainPanel(this.getPermission());
        mainPanel.addErrorListener(this.errorEventSupport_);
        mainPanel.addWorkingListener(this.workingEventSupport_);
        mainPanel.addVObjectListener(this.objectEventSupport_);
        mainPanel.createPermissionMainPanel();
        this.workingEventSupport_.fireStopWorking();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setEnabled(boolean enable) {
        this.enabled_ = enable;
    }
}

