/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelDLO
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private static String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelDLO(PermissionMainPanel mainPanel, Permission permission) {
        this.initializeTable();
        this.mainPanel_ = mainPanel;
        this.permission_ = permission;
        Enumeration userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
    }

    public void addRow(String name) {
        try {
            this.permission_.addAuthorizedUser(name);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration userPermissions = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (userPermissions.hasMoreElements()) {
                this.userPermissions_.addElement(userPermissions.nextElement());
            }
            int updatedRow = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(updatedRow, updatedRow);
        }
        catch (ExtendedIllegalArgumentException e) {
            Trace.log(2, "Error in addRow : " + e);
            this.mainPanel_.fireError(e);
        }
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    public int getColumnCount() {
        return columnNames_.length;
    }

    public String getColumnName(int column) {
        return columnNames_[column];
    }

    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        DLOPermission user = null;
        user = (DLOPermission)this.userPermissions_.elementAt(row);
        String authorityValue = user.getDataAuthority().toUpperCase();
        Object value = null;
        switch (column) {
            case 0: {
                value = new PermissionNameCellObject(user.getUserID(), user.getGroupIndicator());
                break;
            }
            case 1: {
                value = new Boolean(authorityValue.equals("*USE"));
                break;
            }
            case 2: {
                value = new Boolean(authorityValue.equals("*CHANGE"));
                break;
            }
            case 3: {
                value = new Boolean(authorityValue.equals("*ALL"));
                break;
            }
            case 4: {
                value = new Boolean(authorityValue.equals("*EXCLUDE"));
                break;
            }
            case 5: {
                value = new Boolean(user.isFromAuthorizationList());
                break;
            }
            case 6: {
                value = new Boolean(authorityValue.equals("USER_DEF"));
            }
        }
        return value;
    }

    private void initializeTable() {
        columnNames_ = new String[7];
        PermissionTableModelDLO.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        PermissionTableModelDLO.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_USE");
        PermissionTableModelDLO.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_CHANGE");
        PermissionTableModelDLO.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_ALL");
        PermissionTableModelDLO.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_EXCLUDE");
        PermissionTableModelDLO.columnNames_[5] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        PermissionTableModelDLO.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_USER_DEF");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    public boolean isCellEditable(int row, int column) {
        this.selectedColumn_ = column;
        switch (column) {
            case 0: {
                return false;
            }
            case 5: {
                UserPermission user = (UserPermission)this.userPermissions_.elementAt(row);
                return !this.mainPanel_.getAutList().toUpperCase().equals("*NONE") && user.getUserID().toUpperCase().equals("*PUBLIC");
            }
            case 6: {
                return false;
            }
        }
        return true;
    }

    public void removeRow(int row) {
        this.table_.clearSelection();
        DLOPermission user = (DLOPermission)this.userPermissions_.elementAt(row);
        this.permission_.removeUserPermission(user);
        Enumeration userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
        this.fireTableRowsDeleted(row, row);
    }

    void resetPublicAuthorizationList() {
        UserPermission up = this.permission_.getUserPermission("*PUBLIC");
        int row = this.userPermissions_.indexOf(up);
        if (row >= 0) {
            this.setValueAt(new Boolean(false), row, 5);
        }
    }

    public void setTableInstance(JTable table) {
        this.table_ = table;
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        DLOPermission user = (DLOPermission)this.userPermissions_.elementAt(row);
        switch (column) {
            case 1: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setDataAuthority("*Use");
                break;
            }
            case 2: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setDataAuthority("*Change");
                break;
            }
            case 3: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setDataAuthority("*All");
                break;
            }
            case 4: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setDataAuthority("*Exclude");
                break;
            }
            case 5: {
                boolean value = (Boolean)aValue;
                user.setFromAuthorizationList(value);
            }
        }
        this.fireTableRowsUpdated(row, row);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

