/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelQSYS
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private boolean isAuthorizationList_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelQSYS(PermissionMainPanel mainPanel, Permission permission) {
        QSYSObjectPathName objectPathName = new QSYSObjectPathName(permission.getObjectPath());
        this.isAuthorizationList_ = objectPathName.getObjectType().toUpperCase().equals("AUTL");
        this.mainPanel_ = mainPanel;
        this.permission_ = permission;
        this.initializeTable();
        Enumeration userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
    }

    public void addRow(String name) {
        try {
            this.permission_.addAuthorizedUser(name);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration userPermissions = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (userPermissions.hasMoreElements()) {
                this.userPermissions_.addElement(userPermissions.nextElement());
            }
            int updatedRow = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(updatedRow, updatedRow);
        }
        catch (ExtendedIllegalArgumentException e) {
            Trace.log(2, "Error in addRow : " + e);
            this.mainPanel_.fireError(e);
        }
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    public int getColumnCount() {
        return this.columnNames_.length;
    }

    public String getColumnName(int column) {
        return this.columnNames_[column];
    }

    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        QSYSPermission user = (QSYSPermission)this.userPermissions_.elementAt(row);
        String authorityValue = user.getObjectAuthority().toUpperCase();
        Object value = null;
        switch (column) {
            case 0: {
                value = new PermissionNameCellObject(user.getUserID(), user.getGroupIndicator());
                break;
            }
            case 1: {
                value = new Boolean(authorityValue.equals("*USE"));
                break;
            }
            case 2: {
                value = new Boolean(authorityValue.equals("*CHANGE"));
                break;
            }
            case 3: {
                value = new Boolean(authorityValue.equals("*ALL"));
                break;
            }
            case 4: {
                value = new Boolean(authorityValue.equals("*EXCLUDE"));
                break;
            }
            case 5: {
                if (this.isAuthorizationList_) {
                    value = new Boolean(user.isAuthorizationListManagement());
                    break;
                }
                value = new Boolean(user.isFromAuthorizationList());
                break;
            }
            case 6: {
                value = new Boolean(user.isOperational());
                break;
            }
            case 7: {
                value = new Boolean(user.isManagement());
                break;
            }
            case 8: {
                value = new Boolean(user.isExistence());
                break;
            }
            case 9: {
                value = new Boolean(user.isAlter());
                break;
            }
            case 10: {
                value = new Boolean(user.isReference());
                break;
            }
            case 11: {
                value = new Boolean(user.isRead());
                break;
            }
            case 12: {
                value = new Boolean(user.isAdd());
                break;
            }
            case 13: {
                value = new Boolean(user.isUpdate());
                break;
            }
            case 14: {
                value = new Boolean(user.isDelete());
                break;
            }
            case 15: {
                value = new Boolean(user.isExecute());
            }
        }
        return value;
    }

    private void initializeTable() {
        this.columnNames_ = new String[16];
        this.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        this.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_USE");
        this.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_CHANGE");
        this.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_ALL");
        this.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_EXCLUDE");
        if (this.isAuthorizationList_) {
            this.mainPanel_.getListField().setEnabled(false);
            this.columnNames_[5] = ResourceLoader.getText("OBJECT_LIST_MANAGEMENT");
        } else {
            this.columnNames_[5] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        }
        this.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_OPERATION");
        this.columnNames_[7] = ResourceLoader.getText("OBJECT_AUTHORITY_MANAGEMENT");
        this.columnNames_[8] = ResourceLoader.getText("OBJECT_AUTHORITY_EXISTENCE");
        this.columnNames_[9] = ResourceLoader.getText("OBJECT_AUTHORITY_ALTER");
        this.columnNames_[10] = ResourceLoader.getText("OBJECT_AUTHORITY_REFERENCE");
        this.columnNames_[11] = ResourceLoader.getText("OBJECT_AUTHORITY_READ");
        this.columnNames_[12] = ResourceLoader.getText("OBJECT_AUTHORITY_ADD");
        this.columnNames_[13] = ResourceLoader.getText("OBJECT_AUTHORITY_UPDATE");
        this.columnNames_[14] = ResourceLoader.getText("OBJECT_AUTHORITY_DELETE");
        this.columnNames_[15] = ResourceLoader.getText("OBJECT_AUTHORITY_EXECUTE");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    public boolean isCellEditable(int row, int column) {
        this.selectedColumn_ = column;
        switch (column) {
            case 0: {
                return false;
            }
            case 5: {
                UserPermission user = (UserPermission)this.userPermissions_.elementAt(row);
                if (!(this.isAuthorizationList_ ? user.getUserID().toUpperCase().equals("*PUBLIC") : this.mainPanel_.getAutList().toUpperCase().equals("*NONE") || !user.getUserID().toUpperCase().equals("*PUBLIC"))) break;
                return false;
            }
        }
        return true;
    }

    public void removeRow(int row) {
        this.table_.clearSelection();
        QSYSPermission user = (QSYSPermission)this.userPermissions_.elementAt(row);
        this.permission_.removeAuthorizedUser(user.getUserID());
        Enumeration userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
        this.fireTableRowsDeleted(row, row);
    }

    void resetPublicAuthorizationList() {
        UserPermission up = this.permission_.getUserPermission("*PUBLIC");
        int row = this.userPermissions_.indexOf(up);
        if (row >= 0) {
            this.setValueAt(new Boolean(false), row, 5);
        }
    }

    public void setTableInstance(JTable table) {
        this.table_ = table;
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        QSYSPermission user = (QSYSPermission)this.userPermissions_.elementAt(row);
        switch (column) {
            case 1: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setObjectAuthority("*Use");
                break;
            }
            case 2: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setObjectAuthority("*Change");
                break;
            }
            case 3: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setObjectAuthority("*All");
                break;
            }
            case 4: {
                boolean value = (Boolean)aValue;
                if (!value) break;
                user.setObjectAuthority("*Exclude");
                user.setAuthorizationListManagement(false);
                break;
            }
            case 5: {
                boolean value = (Boolean)aValue;
                if (this.isAuthorizationList_) {
                    user.setAuthorizationListManagement(value);
                    break;
                }
                user.setFromAuthorizationList(value);
                break;
            }
            case 6: {
                boolean value = (Boolean)aValue;
                user.setOperational(value);
                break;
            }
            case 7: {
                boolean value = (Boolean)aValue;
                user.setManagement(value);
                break;
            }
            case 8: {
                boolean value = (Boolean)aValue;
                user.setExistence(value);
                break;
            }
            case 9: {
                boolean value = (Boolean)aValue;
                user.setAlter(value);
                break;
            }
            case 10: {
                boolean value = (Boolean)aValue;
                user.setReference(value);
                break;
            }
            case 11: {
                boolean value = (Boolean)aValue;
                user.setRead(value);
                break;
            }
            case 12: {
                boolean value = (Boolean)aValue;
                user.setAdd(value);
                break;
            }
            case 13: {
                boolean value = (Boolean)aValue;
                user.setUpdate(value);
                break;
            }
            case 14: {
                boolean value = (Boolean)aValue;
                user.setDelete(value);
                break;
            }
            case 15: {
                boolean value = (Boolean)aValue;
                user.setExecute(value);
            }
        }
        this.fireTableRowsUpdated(row, row);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

