/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.RecordListData;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class RecordListTableModel
extends AbstractTableModel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    private RecordListData tableData_ = new RecordListData();
    private transient int numColumns_ = 0;
    private static final int READ_INCREMENT_ = 20;
    private transient int numRows_ = 0;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workListeners_ = new WorkingEventSupport(this);
    private transient ErrorListener_ errorListener_ = new ErrorListener_();
    transient boolean error_;

    public RecordListTableModel() {
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public RecordListTableModel(AS400 system, String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.tableData_.setFileName(fileName);
        this.tableData_.setSystem(system);
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public RecordListTableModel(AS400 system, String fileName, Object[] key, int searchType) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.tableData_.setFileName(fileName);
        this.tableData_.setSystem(system);
        this.tableData_.setKeyed(true);
        this.tableData_.setKey(key);
        this.tableData_.setSearchType(searchType);
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workListeners_.addWorkingListener(listener);
    }

    public void close() {
        this.tableData_.close();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this.numColumns_) {
            Trace.log(4, "getColumnClass() error - index out of bounds.");
            return null;
        }
        Object value = null;
        for (int i = 0; i < this.getRowCount() && value == null; ++i) {
            value = this.getValueAt(i, columnIndex);
        }
        if (value != null) {
            return value.getClass();
        }
        try {
            return Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public int getColumnCount() {
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getColumnCount:", this.numColumns_);
        }
        return this.numColumns_;
    }

    public String getColumnID(int columnIndex) {
        if (columnIndex >= this.numColumns_) {
            Trace.log(4, "getColumnID() error - index out of bounds.");
            return null;
        }
        return this.tableData_.getColumnName(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex >= this.numColumns_) {
            Trace.log(4, "getColumnName() error - index out of bounds.");
            return null;
        }
        return this.tableData_.getColumnLabel(columnIndex);
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex >= this.numColumns_) {
            Trace.log(4, "getColumnWidth() error - index out of bounds.");
            return 0;
        }
        return this.tableData_.getColumnDisplaySize(columnIndex);
    }

    public String getFileName() {
        String result = this.tableData_.getFileName();
        if (result == null) {
            return "";
        }
        return result;
    }

    public Object[] getKey() {
        return this.tableData_.getKey();
    }

    public boolean getKeyed() {
        return this.tableData_.getKeyed();
    }

    public int getRowCount() {
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getRowCount:", this.numRows_);
        }
        return this.numRows_;
    }

    public int getSearchType() {
        return this.tableData_.getSearchType();
    }

    public AS400 getSystem() {
        return this.tableData_.getSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableModelEvent event = null;
        this.error_ = false;
        RecordListTableModel recordListTableModel = this;
        synchronized (recordListTableModel) {
            Trace.log(1, "getValueAt[" + rowIndex + "][" + columnIndex + "]");
            if (this.tableData_ == null) {
                Trace.log(4, "getValueAt() error - no load done.");
                return null;
            }
            if (columnIndex >= this.numColumns_) {
                Trace.log(4, "getValueAt() error - column index out of range.");
                return null;
            }
            if (this.tableData_.getAllRecordsProcessed() && rowIndex >= this.tableData_.getNumberOfRows()) {
                Trace.log(4, "getValueAt() error - row out of range.");
                return null;
            }
            this.error_ = false;
            if (this.tableData_.getLastRecordProcessed() < rowIndex) {
                if (rowIndex - this.tableData_.getLastRecordProcessed() > 20) {
                    this.tableData_.readMoreRecords(rowIndex - this.tableData_.getLastRecordProcessed());
                } else {
                    this.tableData_.readMoreRecords(20);
                }
                int oldnum = this.numRows_;
                if (this.tableData_.getAllRecordsProcessed()) {
                    this.numRows_ = this.tableData_.getLastRecordProcessed() + 1;
                    Trace.log(3, "All rows read, number of rows:", this.numRows_);
                    if (rowIndex >= this.tableData_.getNumberOfRows()) {
                        Trace.log(4, "getValueAt() error - row out of range(2).");
                        this.error_ = true;
                    }
                } else {
                    this.numRows_ = this.tableData_.getLastRecordProcessed() + 2;
                }
                event = new TableModelEvent(this, oldnum, this.numRows_ - 1, -1, 1);
            }
        }
        if (event != null) {
            this.fireTableChanged(event);
            Trace.log(3, "Changed number of rows to:", this.numRows_);
        }
        if (this.error_) {
            return null;
        }
        return this.tableData_.getValueAt(rowIndex, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Trace.log(1, "Doing model load.");
        TableModelEvent event = null;
        int oldnum = 0;
        RecordListTableModel recordListTableModel = this;
        synchronized (recordListTableModel) {
            oldnum = this.numRows_ - 1;
            if (this.numRows_ > 0) {
                this.numColumns_ = 0;
                this.numRows_ = 0;
                event = new TableModelEvent(this, 0, oldnum, -1, -1);
            }
        }
        if (event != null) {
            this.fireTableChanged(event);
            Trace.log(3, "Starting load, changed number of rows to:", this.numRows_);
        }
        if (this.tableData_.getSystem() == null) {
            throw new IllegalStateException("system");
        }
        if (this.tableData_.getFileName() == null) {
            throw new IllegalStateException("fileName");
        }
        recordListTableModel = this;
        synchronized (recordListTableModel) {
            this.error_ = false;
            this.tableData_.load();
            if (this.error_) {
                return;
            }
            this.numColumns_ = this.tableData_.getNumberOfColumns();
            this.numRows_ = this.tableData_.getAllRecordsProcessed() ? this.tableData_.getNumberOfRows() : 1;
        }
        if (this.numRows_ > 0) {
            event = new TableModelEvent(this, 0, this.numRows_ - 1, -1, 1);
            this.fireTableChanged(event);
            Trace.log(3, "Did load, changed number of rows to:", this.numRows_);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workListeners_ = new WorkingEventSupport(this);
        this.errorListener_ = new ErrorListener_();
        this.numRows_ = 0;
        this.numColumns_ = 0;
        this.tableData_.addErrorListener(this.errorListener_);
        this.tableData_.addWorkingListener(this.workListeners_);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workListeners_.removeWorkingListener(listener);
    }

    public void setFileName(String fileName) throws PropertyVetoException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        String old = this.getFileName();
        this.vetoListeners_.fireVetoableChange("fileName", old, fileName);
        this.tableData_.setFileName(fileName);
        this.changeListeners_.firePropertyChange("fileName", old, fileName);
    }

    public void setKey(Object[] key) throws PropertyVetoException {
        Object[] old = this.getKey();
        this.vetoListeners_.fireVetoableChange("key", old, key);
        this.tableData_.setKey(key);
        this.changeListeners_.firePropertyChange("key", old, key);
    }

    public void setKeyed(boolean keyed) throws PropertyVetoException {
        Boolean old = new Boolean(this.getKeyed());
        this.vetoListeners_.fireVetoableChange("keyed", old, new Boolean(keyed));
        this.tableData_.setKeyed(keyed);
        this.changeListeners_.firePropertyChange("keyed", old, new Boolean(keyed));
    }

    public void setSearchType(int searchType) throws PropertyVetoException {
        int old = this.getSearchType();
        this.vetoListeners_.fireVetoableChange("searchType", new Integer(old), new Integer(searchType));
        this.tableData_.setSearchType(searchType);
        this.changeListeners_.firePropertyChange("searchType", new Integer(old), new Integer(searchType));
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 old = this.getSystem();
        this.vetoListeners_.fireVetoableChange("system", old, system);
        this.tableData_.setSystem(system);
        this.changeListeners_.firePropertyChange("system", old, system);
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        public void errorOccurred(ErrorEvent event) {
            RecordListTableModel.this.error_ = true;
            RecordListTableModel.this.errorListeners_.fireError(event.getException());
        }
    }
}

