/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.TableModelEventSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResourceListDetailsModel
implements TableModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String RESOURCE_COLUMN_NAME_ = ResourceLoader.getText("RESOURCE_COLUMN_NAME");
    private static final int COLUMN_SOURCE_NOT_KNOWN_ = 0;
    private static final int COLUMN_SOURCE_RESOURCE_ = 1;
    private static final int COLUMN_SOURCE_RESOURCE_ATTRIBUTE_ = 2;
    private static final int COLUMN_SOURCE_NOT_VALID_ = 99;
    private boolean exceptionOccured_ = false;
    private transient boolean loaded_ = false;
    private ResourceList resourceList_ = null;
    private Object[] columnAttributeIDs_ = null;
    private int[] columnSources_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient ResourceListListener resourceListListener_;
    transient TableModelEventSupport tableModelEventSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public ResourceListDetailsModel() {
        this.initializeTransient();
    }

    public ResourceListDetailsModel(ResourceList resourceList, Object[] columnAttributeIDs) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        this.initializeTransient();
        this.setResourceList(resourceList);
        this.setColumnAttributeIDs(columnAttributeIDs);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tableModelEventSupport_.addTableModelListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Object[] getColumnAttributeIDs() {
        return this.columnAttributeIDs_;
    }

    public Class getColumnClass(int columnIndex) {
        switch (this.getColumnSource(columnIndex)) {
            case 1: {
                return Resource.class;
            }
            case 2: {
                return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]).getType();
            }
        }
        return null;
    }

    public int getColumnCount() {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return 0;
        }
        return this.columnAttributeIDs_.length;
    }

    public String getColumnName(int columnIndex) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return null;
        }
        switch (this.getColumnSource(columnIndex)) {
            case 1: {
                return RESOURCE_COLUMN_NAME_;
            }
            case 2: {
                return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]).getPresentation().getName();
            }
        }
        if (columnIndex < 0 || columnIndex >= this.columnAttributeIDs_.length) {
            return null;
        }
        return this.columnAttributeIDs_[columnIndex].toString();
    }

    private int getColumnSource(int columnIndex) {
        if (this.columnAttributeIDs_ == null) {
            return 99;
        }
        if (columnIndex < 0 || columnIndex >= this.columnAttributeIDs_.length) {
            return 99;
        }
        if (this.columnSources_[columnIndex] == 0) {
            if (this.columnAttributeIDs_[columnIndex] == null) {
                this.columnSources_[columnIndex] = 1;
            } else {
                try {
                    ResourceMetaData attributeMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]);
                    this.columnSources_[columnIndex] = 2;
                }
                catch (IllegalArgumentException e) {
                    this.columnSources_[columnIndex] = 99;
                }
            }
        }
        return this.columnSources_[columnIndex];
    }

    public int getColumnWidth(int columnIndex) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return 20;
        }
        switch (this.getColumnSource(columnIndex)) {
            default: {
                return 20;
            }
            case 2: 
        }
        int dataWidth = 20;
        ResourceMetaData attributeMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]);
        Class type = attributeMetaData.getType();
        Presentation[] possibleValuePresentations = attributeMetaData.getPossibleValuePresentations();
        if (Number.class.isAssignableFrom(type)) {
            dataWidth = 10;
        } else if (possibleValuePresentations.length > 0) {
            dataWidth = 1;
            for (int i = 0; i < possibleValuePresentations.length; ++i) {
                int nameLength = possibleValuePresentations[i].getName().toString().length();
                if (nameLength <= dataWidth) continue;
                dataWidth = nameLength;
            }
        }
        int nameLength = attributeMetaData.getPresentation().getName().toString().length();
        if (nameLength > dataWidth) {
            dataWidth = nameLength;
        }
        return dataWidth;
    }

    public Resource getResourceAt(int rowIndex) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        try {
            if (rowIndex < 0 || this.resourceList_.isComplete() && (long)rowIndex > this.resourceList_.getListLength()) {
                return null;
            }
            return this.resourceList_.resourceAt(rowIndex);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.exceptionOccured_ = true;
            return null;
        }
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    public int getRowCount() {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return 0;
        }
        try {
            if (!this.resourceList_.isComplete()) {
                this.resourceList_.refreshStatus();
            }
            long listLength = this.resourceList_.getListLength();
            return (int)listLength;
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.exceptionOccured_ = true;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        Resource resource = this.getResourceAt(rowIndex);
        if (resource == null) {
            return null;
        }
        switch (this.getColumnSource(columnIndex)) {
            case 1: {
                return resource;
            }
            case 2: {
                resource.addActiveStatusListener(this.workingEventSupport_);
                try {
                    Object object = resource.getAttributeValue(this.columnAttributeIDs_[columnIndex]);
                    Object var7_6 = null;
                    resource.removeActiveStatusListener(this.workingEventSupport_);
                    return object;
                }
                catch (Exception e) {
                    try {
                        this.errorEventSupport_.fireError(e);
                        this.exceptionOccured_ = true;
                        Object var5_9 = null;
                        Object var7_7 = null;
                        resource.removeActiveStatusListener(this.workingEventSupport_);
                        return var5_9;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        resource.removeActiveStatusListener(this.workingEventSupport_);
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListener_ = new ResourceListListener_();
        this.tableModelEventSupport_ = new TableModelEventSupport(this, this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.resourceList_ != null) {
            this.resourceList_.addActiveStatusListener(this.workingEventSupport_);
            this.resourceList_.addResourceListListener(this.resourceListListener_);
        }
    }

    public void load() {
        if (this.loaded_ && this.resourceList_ != null && !this.exceptionOccured_) {
            try {
                this.resourceList_.refreshContents();
            }
            catch (Exception e) {
                this.errorEventSupport_.fireError(e);
                this.exceptionOccured_ = true;
            }
        } else {
            this.loaded_ = true;
        }
        this.tableModelEventSupport_.fireTableChanged(-1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableModelEventSupport_.removeTableModelListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setColumnAttributeIDs(Object[] columnAttributeIDs) {
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        Object[] oldValue = this.columnAttributeIDs_;
        if (oldValue != columnAttributeIDs) {
            this.columnAttributeIDs_ = columnAttributeIDs;
            this.columnSources_ = new int[this.columnAttributeIDs_.length];
            this.tableModelEventSupport_.fireTableChanged(-1);
        }
        this.propertyChangeSupport_.firePropertyChange("columnAttributeIDs", oldValue, this.columnAttributeIDs_);
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList oldValue = this.resourceList_;
        if (oldValue != resourceList) {
            if (oldValue != null) {
                oldValue.removeActiveStatusListener(this.workingEventSupport_);
                oldValue.removeResourceListListener(this.resourceListListener_);
            }
            resourceList.addActiveStatusListener(this.workingEventSupport_);
            resourceList.addResourceListListener(this.resourceListListener_);
            this.resourceList_ = resourceList;
            this.exceptionOccured_ = false;
            if (this.columnAttributeIDs_ != null) {
                this.columnSources_ = new int[this.columnAttributeIDs_.length];
            }
            this.tableModelEventSupport_.fireTableChanged(-1);
        }
        this.propertyChangeSupport_.firePropertyChange("resourceList", oldValue, this.resourceList_);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    private class ResourceListListener_
    implements ResourceListListener {
        private long length_ = 0L;

        private ResourceListListener_() {
        }

        public void lengthChanged(ResourceListEvent event) {
            long newLength = event.getLength();
            ResourceListDetailsModel.this.tableModelEventSupport_.fireTableChanged((int)this.length_, (int)newLength, -1, 1);
            this.length_ = newLength;
        }

        public void listClosed(ResourceListEvent event) {
        }

        public void listCompleted(ResourceListEvent event) {
        }

        public void listInError(ResourceListEvent event) {
        }

        public void listOpened(ResourceListEvent event) {
        }

        public void resourceAdded(ResourceListEvent event) {
        }
    }
}

