/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

class ResourceListPropertiesTabbedPane
extends JComponent {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String DLG_ADD_ = ResourceLoader.getText("DLG_ADD");
    private static final String DLG_REMOVE_ = ResourceLoader.getText("DLG_REMOVE");
    private static final String RESOURCE_ALL_SORTS_ = ResourceLoader.getText("RESOURCE_ALL_SORTS");
    private static final String RESOURCE_CURRENT_SORTS_ = ResourceLoader.getText("RESOURCE_CURRENT_SORTS");
    private static final String RESOURCE_SELECTION_TAB_ = ResourceLoader.getText("RESOURCE_SELECTION_TAB");
    private static final String RESOURCE_SORT_TAB_ = ResourceLoader.getText("RESOURCE_SORT_TAB");
    private Hashtable changes_ = new Hashtable();
    private DefaultListModel currentSortsModel_;
    private Presentation presentation_;
    private ResourceList resourceList_;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);

    public ResourceListPropertiesTabbedPane(ResourceList resourceList) {
        this.resourceList_ = resourceList;
        this.presentation_ = resourceList.getPresentation();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(RESOURCE_SELECTION_TAB_, this.createSelectionComponent());
        if (resourceList.getSortMetaData().length > 0) {
            tabbedPane.addTab(RESOURCE_SORT_TAB_, this.createSortComponent());
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabbedPane);
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void applyChanges() {
        this.applyChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(boolean refreshContents) {
        Hashtable hashtable = this.changes_;
        synchronized (hashtable) {
            try {
                Enumeration selectionIDs = this.changes_.keys();
                while (selectionIDs.hasMoreElements()) {
                    Object selectionID = selectionIDs.nextElement();
                    Object value = this.changes_.get(selectionID);
                    this.resourceList_.setSelectionValue(selectionID, value);
                }
                this.changes_.clear();
                if (this.currentSortsModel_ != null) {
                    this.resourceList_.setSortValue(this.currentSortsModel_.toArray());
                }
                if (refreshContents) {
                    this.resourceList_.refreshContents();
                }
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error applying changes", (Throwable)e);
                }
                this.errorEventSupport_.fireError(e);
            }
        }
    }

    private Component createSelectionComponent(ResourceMetaData rmd) throws ResourceException {
        Object selectionID = rmd.getID();
        Object initialValue = this.resourceList_.getSelectionValue(selectionID);
        boolean editable = !rmd.isReadOnly();
        JComponent component = null;
        Class type = rmd.getType();
        Object[] possibleValues = rmd.getPossibleValues();
        if (type == Boolean.class) {
            JCheckBox checkBox = new JCheckBox("", (boolean)((Boolean)initialValue));
            checkBox.setEnabled(editable);
            checkBox.addActionListener(new ChangeListener_(selectionID));
            component = checkBox;
        } else if (possibleValues != null && possibleValues.length > 0) {
            if (editable) {
                JComboBox<Object> comboBox = new JComboBox<Object>();
                if (initialValue.getClass().isArray()) {
                    initialValue = ((Object[])initialValue)[0];
                }
                boolean initialValueFound = false;
                for (int i = 0; i < possibleValues.length; ++i) {
                    comboBox.addItem(possibleValues[i]);
                    if (possibleValues[i] != initialValue) continue;
                    initialValueFound = true;
                }
                if (!initialValueFound) {
                    comboBox.addItem(initialValue);
                }
                comboBox.setRenderer(new JComboBoxRenderer(rmd));
                comboBox.setEditor(new JComboBoxEditor(rmd));
                comboBox.setEditable(!rmd.isValueLimited());
                ChangeListener_ changeListener = new ChangeListener_(selectionID, comboBox.getEditor());
                comboBox.addItemListener(changeListener);
                comboBox.getEditor().getEditorComponent().addKeyListener(changeListener);
                comboBox.setSelectedItem(initialValue);
                component = comboBox;
            } else {
                component = new JLabel(rmd.getPossibleValuePresentation(initialValue).getFullName());
            }
        }
        if (component == null) {
            if (editable) {
                JTextField textField = new JTextField(initialValue.toString());
                textField.addKeyListener(new ChangeListener_(selectionID));
                component = textField;
            } else {
                component = new JLabel(initialValue.toString());
            }
        }
        return component;
    }

    private Component createSelectionBox() {
        Box leftBox = new Box(1);
        Box rightBox = new Box(1);
        Box selectionBox = new Box(0);
        selectionBox.add(leftBox);
        selectionBox.add(Box.createRigidArea(new Dimension(10, 0)));
        selectionBox.add(rightBox);
        selectionBox.add(Box.createHorizontalGlue());
        ResourceMetaData[] rmd = this.resourceList_.getSelectionMetaData();
        for (int i = 0; i < rmd.length; ++i) {
            Presentation presentation2 = rmd[i].getPresentation();
            String componentLabel = null;
            componentLabel = presentation2 != null ? presentation2.getFullName() : rmd[i].getID().toString();
            JLabel leftComponent = new JLabel(componentLabel + ':');
            leftBox.add(leftComponent);
            int leftComponentSize = ((Component)leftComponent).getPreferredSize().height;
            int rightComponentSize = 0;
            try {
                Component rightComponent = this.createSelectionComponent(rmd[i]);
                rightBox.add(rightComponent);
                rightComponentSize = rightComponent.getPreferredSize().height;
            }
            catch (ResourceException e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error creating property component for:" + rmd[i].getID(), (Throwable)e);
                }
                this.errorEventSupport_.fireError(e);
            }
            int diff = leftComponentSize - rightComponentSize;
            if (diff > 0) {
                rightBox.add(Box.createRigidArea(new Dimension(0, diff)));
            } else if (diff < 0) {
                leftBox.add(Box.createRigidArea(new Dimension(0, -diff)));
            }
            leftBox.add(Box.createRigidArea(new Dimension(0, 3)));
            rightBox.add(Box.createRigidArea(new Dimension(0, 3)));
        }
        leftBox.add(Box.createVerticalGlue());
        rightBox.add(Box.createVerticalGlue());
        return selectionBox;
    }

    private Component createSelectionComponent() {
        Box overallBox = new Box(1);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", overallBox);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(this.presentation_.getFullName(), new ImageIcon((Image)this.presentation_.getValue("32")), 2);
        Box labelBox = new Box(0);
        labelBox.add(label);
        labelBox.add(Box.createHorizontalGlue());
        overallBox.add(labelBox);
        JSeparator separator = new JSeparator();
        separator.setMaximumSize(new Dimension(separator.getMaximumSize().width, separator.getPreferredSize().height));
        overallBox.add(Box.createRigidArea(new Dimension(0, 6)));
        overallBox.add(separator);
        overallBox.add(Box.createRigidArea(new Dimension(0, 6)));
        overallBox.add(this.createSelectionBox());
        overallBox.add(Box.createVerticalGlue());
        return panel;
    }

    private Component createSortComponent() {
        Box overallBox = new Box(0);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", overallBox);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel allSortsPanel = new JPanel();
        allSortsPanel.setLayout(new BorderLayout());
        allSortsPanel.add("North", new JLabel(RESOURCE_ALL_SORTS_, 2));
        DefaultListModel<Object> allSortsModel = new DefaultListModel<Object>();
        ResourceMetaData[] smd = this.resourceList_.getSortMetaData();
        for (int i = 0; i < smd.length; ++i) {
            allSortsModel.addElement(smd[i].getID());
        }
        JList<Object> allSortsList = new JList<Object>(allSortsModel);
        allSortsList.setBorder(new EtchedBorder());
        allSortsList.setAlignmentX(0.0f);
        ListCellRenderer_ listCellRenderer = new ListCellRenderer_();
        allSortsList.setCellRenderer(listCellRenderer);
        allSortsPanel.add("Center", allSortsList);
        overallBox.add(allSortsPanel);
        overallBox.add(Box.createRigidArea(new Dimension(6, 0)));
        Box buttonBox = new Box(1);
        buttonBox.add(Box.createVerticalGlue());
        JButton addButton = new JButton(DLG_ADD_);
        addButton.setAlignmentX(0.5f);
        addButton.setEnabled(false);
        buttonBox.add(addButton);
        buttonBox.add(Box.createRigidArea(new Dimension(0, 6)));
        JButton removeButton = new JButton(DLG_REMOVE_);
        removeButton.setAlignmentX(0.5f);
        removeButton.setEnabled(false);
        buttonBox.add(removeButton);
        buttonBox.add(Box.createVerticalGlue());
        overallBox.add(buttonBox);
        overallBox.add(Box.createRigidArea(new Dimension(6, 0)));
        JPanel currentSortsPanel = new JPanel();
        currentSortsPanel.setLayout(new BorderLayout());
        currentSortsPanel.add("North", new JLabel(RESOURCE_CURRENT_SORTS_, 2));
        this.currentSortsModel_ = new DefaultListModel();
        JList<Object> currentSortsList = new JList<Object>(this.currentSortsModel_);
        currentSortsList.setBorder(new EtchedBorder());
        currentSortsList.setAlignmentX(0.0f);
        currentSortsList.setCellRenderer(listCellRenderer);
        currentSortsPanel.add("Center", currentSortsList);
        overallBox.add(currentSortsPanel);
        allSortsList.addListSelectionListener(new ListSelectionListener_(addButton));
        currentSortsList.addListSelectionListener(new ListSelectionListener_(removeButton));
        addButton.addActionListener(new SortMover_(allSortsList, allSortsModel, this.currentSortsModel_));
        removeButton.addActionListener(new SortMover_(currentSortsList, this.currentSortsModel_, allSortsModel));
        ActionListener applyEnabler = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ResourceListPropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
            }
        };
        addButton.addActionListener(applyEnabler);
        removeButton.addActionListener(applyEnabler);
        return panel;
    }

    private class SortMover_
    implements ActionListener {
        private JList fromList_;
        private DefaultListModel fromModel_;
        private DefaultListModel toModel_;

        public SortMover_(JList fromList, DefaultListModel fromModel, DefaultListModel toModel) {
            this.fromList_ = fromList;
            this.fromModel_ = fromModel;
            this.toModel_ = toModel;
        }

        public void actionPerformed(ActionEvent event) {
            Object[] selectedValues = this.fromList_.getSelectedValues();
            for (int i = 0; i < selectedValues.length; ++i) {
                this.fromModel_.removeElement(selectedValues[i]);
                this.toModel_.addElement(selectedValues[i]);
            }
            ((JButton)event.getSource()).setEnabled(false);
        }
    }

    private class ListSelectionListener_
    implements ListSelectionListener {
        private JButton button_;

        public ListSelectionListener_(JButton button) {
            this.button_ = button;
        }

        public void valueChanged(ListSelectionEvent event) {
            this.button_.setEnabled(((JList)event.getSource()).getMinSelectionIndex() >= 0);
        }
    }

    private class ListCellRenderer_
    extends DefaultListCellRenderer {
        private ListCellRenderer_() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object fullName = value;
            ResourceMetaData rmd = ResourceListPropertiesTabbedPane.this.resourceList_.getSortMetaData(value);
            if (rmd != null) {
                fullName = rmd.getPresentation().getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)list, fullName, index, isSelected, cellHasFocus);
        }
    }

    private class JComboBoxEditor
    extends BasicComboBoxEditor {
        private ResourceMetaData metaData_;
        private Object actualValue_ = null;
        private String fullName_ = null;

        public JComboBoxEditor(ResourceMetaData metaData) {
            this.metaData_ = metaData;
        }

        public Object getItem() {
            Object value = super.getItem();
            if (this.fullName_ != null && value.equals(this.fullName_)) {
                return this.actualValue_;
            }
            return value;
        }

        public void setItem(Object value) {
            if (value != null) {
                try {
                    Presentation presentation = this.metaData_.getPossibleValuePresentation(value);
                    this.fullName_ = presentation != null ? presentation.getFullName() : value.toString();
                    this.actualValue_ = value;
                }
                catch (Exception e) {
                    this.fullName_ = null;
                    this.actualValue_ = null;
                }
            }
            super.setItem(this.fullName_);
        }
    }

    private class JComboBoxRenderer
    extends DefaultListCellRenderer {
        private ResourceMetaData metaData_;

        public JComboBoxRenderer(ResourceMetaData metaData) {
            this.metaData_ = metaData;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Presentation presentation;
            Object fullName = value;
            if (value != null && (presentation = this.metaData_.getPossibleValuePresentation(value)) != null) {
                fullName = presentation.getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)list, fullName, index, isSelected, cellHasFocus);
        }
    }

    private class ChangeListener_
    extends KeyAdapter
    implements ActionListener,
    ItemListener {
        private Object selectionID_;
        private ComboBoxEditor editor_;

        public ChangeListener_(Object selectionID) {
            this.selectionID_ = selectionID;
        }

        public ChangeListener_(Object selectionID, ComboBoxEditor editor) {
            this.selectionID_ = selectionID;
            this.editor_ = editor;
        }

        public void actionPerformed(ActionEvent event) {
            this.registerChange(new Boolean(((JCheckBox)event.getSource()).isSelected()));
        }

        public void itemStateChanged(ItemEvent event) {
            this.registerChange(event.getItem());
        }

        public void keyTyped(KeyEvent event) {
            this.registerChange(this.editor_.getItem());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChange(Object value) {
            Hashtable hashtable = ResourceListPropertiesTabbedPane.this.changes_;
            synchronized (hashtable) {
                ResourceListPropertiesTabbedPane.this.changes_.put(this.selectionID_, value);
            }
            ResourceListPropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
        }
    }
}

