/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.DoubleClickList;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.ScrollingTextPane;
import com.ibm.as400.vaccess.SerializationListener;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JComponent;

class SQLQueryOrderPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SQLQueryBuilderPane parent_;
    private transient DoubleClickList selectItems_;
    DoubleClickList otherList_;
    private SQLQueryClause clause_;
    boolean selectChanged_ = false;
    private String[] selectFields_;
    protected SelectListener_ selectListener_ = null;
    private boolean inited_ = false;
    private static final String[] otherChoices = new String[]{"ASC", "DESC"};

    public SQLQueryOrderPane(SQLQueryBuilderPane parent) {
        this.parent_ = parent;
        this.initializeTransient();
    }

    public String getClause() {
        if (this.clause_ == null) {
            return null;
        }
        return this.clause_.getText();
    }

    public void init() {
        this.selectListener_ = new SelectListener_();
        this.parent_.addSelectListener(this.selectListener_);
        this.setupPane();
        this.inited_ = true;
    }

    private void initializeTransient() {
        this.addFocusListener(new SerializationListener(this));
        if (this.inited_) {
            this.init();
        }
    }

    void otherPicked(String item) {
        this.clause_.appendText(item);
        this.otherList_.setEnabled(false);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    protected void rowPicked() {
        String item = (String)this.selectItems_.getSelectedObjects()[0];
        this.clause_.appendTextWithComma(item);
        this.otherList_.setEnabled(true);
    }

    private boolean isField(String item) {
        for (int i = 0; i < this.selectFields_.length; ++i) {
            if (!item.equals(this.selectFields_[i])) continue;
            return true;
        }
        return false;
    }

    protected void setupPane() {
        this.selectFields_ = this.parent_.getSelectedFields();
        this.selectItems_ = new DoubleClickList(this.parent_.getSelectedItems());
        this.selectItems_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                SQLQueryOrderPane.this.rowPicked();
            }
        });
        this.otherList_ = new DoubleClickList(otherChoices);
        this.otherList_.setVisibleRowCount(2);
        this.otherList_.setEnabled(false);
        this.otherList_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                SQLQueryOrderPane.this.otherPicked((String)event.getItem());
            }
        });
        Box topRow = Box.createHorizontalBox();
        topRow.add(new LabelledComponent("DBQUERY_COLUMN_SELECT", this.selectItems_));
        topRow.add(new LabelledComponent("DBQUERY_LABEL_OTHER", this.otherList_));
        this.clause_ = new SQLQueryClause(5);
        Box overallBox = Box.createVerticalBox();
        overallBox.add(topRow);
        overallBox.add(new LabelledComponent("DBQUERY_LABEL_CLAUSE_ORDER", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", overallBox);
    }

    public void update() {
        if (this.selectChanged_) {
            this.selectItems_.setListData(this.parent_.getSelectedItems());
            this.selectFields_ = this.parent_.getSelectedFields();
            this.selectChanged_ = false;
        }
    }

    private class SelectListener_
    implements PropertyChangeListener {
        private SelectListener_() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            SQLQueryOrderPane.this.selectChanged_ = true;
        }
    }
}

