/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserGroup;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUser;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class UserPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String descriptionText_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String sessionStartupTabText_ = ResourceLoader.getText("TAB_SESSION_STARTUP");
    private static final String displaySessionTabText_ = ResourceLoader.getText("TAB_DISPLAY_SESSION");
    private static final String outputTabText_ = ResourceLoader.getText("TAB_OUTPUT");
    private static final String internationalTabText_ = ResourceLoader.getText("TAB_INTERNATIONAL");
    private static final String otherTabText_ = ResourceLoader.getText("TAB_OTHER");
    private static final String securityTabText_ = ResourceLoader.getText("TAB_SECURITY");
    private static final String groupInformationTabText_ = ResourceLoader.getText("TAB_GROUP_INFORMATION");
    private static final String groupProfileNameText_ = ResourceLoader.getText("USER_GROUP_PROFILE_NAME") + " : ";
    private static final String groupIDNumberText_ = ResourceLoader.getText("USER_GROUP_ID_NUMBER") + " : ";
    private static final String groupAuthorityText_ = ResourceLoader.getText("USER_GROUP_AUTHORITY") + " : ";
    private static final String groupAuthorityTypeText_ = ResourceLoader.getText("USER_GROUP_AUTHORITY_TYPE") + " : ";
    private static final String groupHasMemberText_ = ResourceLoader.getText("USER_GROUP_HAS_MEMBER");
    private static final String groupMembersText_ = ResourceLoader.getText("USER_GROUPS_MEMBERS") + " : ";
    private static final String languageIDText_ = ResourceLoader.getText("USER_LANGUAGE_ID") + " : ";
    private static final String countryIDText_ = ResourceLoader.getText("USER_COUNTRY_ID") + " : ";
    private static final String codedCharacterSetIDText_ = ResourceLoader.getText("USER_CODED_CHARACTER_SET_ID") + " : ";
    private static final String localePathNameText_ = ResourceLoader.getText("USER_LOCALE_PATH_NAME") + " : ";
    private static final String localeJobAttributesText_ = ResourceLoader.getText("USER_LOCALE_JOB_ATTRIBUTES") + " : ";
    private static final String customText_ = ResourceLoader.getText("USER_CUSTOM") + " : ";
    private static final String outputQueueText_ = ResourceLoader.getText("USER_OUTPUT_QUEUE") + ": ";
    private static final String messageQueueText_ = ResourceLoader.getText("USER_MESSAGE_QUEUE") + ": ";
    private static final String printDeviceText_ = ResourceLoader.getText("USER_PRINT_DEVICE") + ": ";
    private static final String messageDeliveryText_ = ResourceLoader.getText("USER_MESSAGE_DELIVERY") + ": ";
    private static final String messageSeverityLevelText_ = ResourceLoader.getText("USER_MESSAGE_SEVERITY_LEVEL") + ": ";
    private static final String ownerText_ = ResourceLoader.getText("USER_OWNER") + ": ";
    private static final String objectAuditingValueText_ = ResourceLoader.getText("USER_OBJECT_AUDITING_VALUE") + ": ";
    private static final String userActionAuditLevelText_ = ResourceLoader.getText("USER_ACTION_AUDIT_LEVEL") + ": ";
    private static final String specialAuthorityText_ = ResourceLoader.getText("USER_SPECIAL_AUTHORITY") + ": ";
    private static final String sortSequeneceTableText_ = ResourceLoader.getText("USER_SORT_SEQUENCE_TABLE") + ": ";
    private static final String storageUsedText_ = ResourceLoader.getText("USER_STORAGE_USED") + ": ";
    private static final String supplementalGroupsNumberText_ = ResourceLoader.getText("USER_SUPPLEMENTAL_GROUPS_NUMBER") + ": ";
    private static final String supplementalGroupsText_ = ResourceLoader.getText("USER_SUPPLEMENTAL_GROUPS") + ": ";
    private static final String specialEnvironmentText_ = ResourceLoader.getText("USER_SPECIAL_ENVIRONMENT") + ": ";
    private static final String daysUntilPasswordExpireText_ = ResourceLoader.getText("USER_DAYS_UNTIL_PASSWORD_EXPIRE") + " : ";
    private static final String isNoPasswordText_ = ResourceLoader.getText("USER_IS_NO_PASSWORD") + " : ";
    private static final String isPasswordSetExpireText_ = ResourceLoader.getText("USER_IS_PASSWORD_SET_EXPIRE") + " : ";
    private static final String isWithDigitalCertificatesText_ = ResourceLoader.getText("USER_IS_WITH_DIGITAL_CERTIFICATES") + " : ";
    private static final String passwordExpireDateText_ = ResourceLoader.getText("USER_PASSWORD_EXPIRE_DATE") + " : ";
    private static final String passwordExpirationIntervalText_ = ResourceLoader.getText("USER_PASSWORD_EXPIRATION_INTERVAL") + " : ";
    private static final String passwordLastChangedDateText_ = ResourceLoader.getText("USER_PASSWORD_LAST_CHANGED_DATE") + " : ";
    private static final String previousSignedOnDateText_ = ResourceLoader.getText("USER_PREVIOUS_SIGNED_ON_DATE") + " : ";
    private static final String signedOnAttemptsNotValidText_ = ResourceLoader.getText("USER_SIGNED_ON_ATTEMPTS_NOT_VALID") + " : ";
    private static final String assistanceLevelText_ = ResourceLoader.getText("USER_ASSISTANCE_LEVEL") + " : ";
    private static final String attentionProgramNameText_ = ResourceLoader.getText("USER_ATTENTION_PROGRAM_NAME") + " : ";
    private static final String limitCapabilitiesText_ = ResourceLoader.getText("USER_LIMIT_CAPABILITIES") + " : ";
    private static final String initialProgramText_ = ResourceLoader.getText("USER_INITIAL_PROGRAM") + " : ";
    private static final String initialMenuText_ = ResourceLoader.getText("USER_INITIAL_MENU") + " : ";
    private static final String displaySignOnInformationText_ = ResourceLoader.getText("USER_DISPLAY_SIGNON_INFORMATION") + " : ";
    private static final String limitDeviceSessionsText_ = ResourceLoader.getText("USER_LIMIT_DEVICE_SESSIONS") + " : ";
    private static final String accountingCodeText_ = ResourceLoader.getText("USER_ACCOUNTING_CODE") + " : ";
    private static final String currentLibText_ = ResourceLoader.getText("USER_CURRENT_LIB") + " : ";
    private static final String highestSchedulePriorityText_ = ResourceLoader.getText("USER_HIGHEST_SCHEDULE_PRIORITY") + " : ";
    private static final String homeDirectoryText_ = ResourceLoader.getText("USER_HOME_DIRECTORY") + " : ";
    private static final String jobDescriptionNameText_ = ResourceLoader.getText("USER_JOB_DESCRIPTION_NAME") + " : ";
    private static final String maximumAllowedStorageText_ = ResourceLoader.getText("USER_MAXIMUM_ALLOWED_STORAGE") + " : ";
    private static final String statusText_ = ResourceLoader.getText("USER_STATUS") + " : ";
    private static final String userClassNameText_ = ResourceLoader.getText("USER_CLASS_NAME") + " : ";
    private static final String userIDNumberText_ = ResourceLoader.getText("USER_ID_NUMBER") + " : ";
    private static final String userProfileNameText_ = ResourceLoader.getText("USER_PROFILE_NAME") + " : ";
    private static final DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static final DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static final String trueText_ = ResourceLoader.getText("DLG_TRUE");
    private static final String falseText_ = ResourceLoader.getText("DLG_FALSE");
    private VUser object_;
    private User user_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public UserPropertiesPane(VUser object, User user) {
        this.object_ = object;
        this.user_ = user;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(generalTabText_, null, this.getGeneralTab());
        tabbedPane.addTab(sessionStartupTabText_, null, this.getSessionStartupTab());
        tabbedPane.addTab(displaySessionTabText_, null, this.getDisplaySessionTab());
        tabbedPane.addTab(outputTabText_, null, this.getOutputTab());
        tabbedPane.addTab(internationalTabText_, null, this.getInternationalTab());
        tabbedPane.addTab(securityTabText_, null, this.getSecurityTab());
        tabbedPane.addTab(groupInformationTabText_, null, this.getGroupInformationTab());
        tabbedPane.addTab(otherTabText_, null, this.getOtherTab());
        tabbedPane.setSelectedIndex(0);
        return tabbedPane;
    }

    private Component getDisplaySessionTab() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        String fullPathName = this.user_.getAttentionKeyHandlingProgram();
        VUtilities.constrain(attentionProgramNameText_, fullPathName, panel, layout, row++);
        VUtilities.constrain(limitCapabilitiesText_, this.user_.getLimitCapabilities(), panel, layout, row++);
        VUtilities.constrain(assistanceLevelText_, this.user_.getAssistanceLevel(), panel, layout, row++);
        return panel;
    }

    private Component getGeneralTab() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(new JLabel(userProfileNameText_, this.object_.getIcon(32, false), 2), new JLabel(this.object_.getText()), panel, layout, row++);
        VUtilities.constrain(descriptionText_, this.user_.getDescription(), panel, layout, row++);
        VUtilities.constrain(userClassNameText_, this.user_.getUserClassName(), panel, layout, row++);
        VUtilities.constrain(userIDNumberText_, Integer.toString(this.user_.getUserIDNumber()), panel, layout, row++);
        VUtilities.constrain(statusText_, this.user_.getStatus(), panel, layout, row++);
        VUtilities.constrain(currentLibText_, this.user_.getCurrentLibraryName(), panel, layout, row++);
        int maxStorageUsed = this.user_.getMaximumStorageAllowed();
        String str = maxStorageUsed == -1 ? "*NOMAX" : Integer.toString(maxStorageUsed);
        VUtilities.constrain(maximumAllowedStorageText_, str, panel, layout, row++);
        VUtilities.constrain(storageUsedText_, Integer.toString(this.user_.getStorageUsed()), panel, layout, row++);
        VUtilities.constrain(highestSchedulePriorityText_, Integer.toString(this.user_.getHighestSchedulingPriority()), panel, layout, row++);
        VUtilities.constrain(accountingCodeText_, this.user_.getAccountingCode(), panel, layout, row++);
        String fullPathName = this.user_.getJobDescription();
        VUtilities.constrain(jobDescriptionNameText_, fullPathName, panel, layout, row++);
        VUtilities.constrain(homeDirectoryText_, this.user_.getHomeDirectory(), panel, layout, row++);
        return panel;
    }

    private Component getGroupInformationTab() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(groupProfileNameText_, this.user_.getGroupProfileName(), panel, layout, row++);
        String grpstr = "";
        int grp = this.user_.getGroupIDNumber();
        grpstr = grp == 0 ? "*NONE" : "" + grp;
        VUtilities.constrain(groupIDNumberText_, grpstr, panel, layout, row++);
        VUtilities.constrain(groupAuthorityText_, this.user_.getGroupAuthority(), panel, layout, row++);
        VUtilities.constrain(groupAuthorityTypeText_, this.user_.getGroupAuthorityType(), panel, layout, row++);
        String value = falseText_;
        if (this.user_.isGroupHasMember()) {
            value = trueText_;
        }
        VUtilities.constrain(groupHasMemberText_, value, panel, layout, row++);
        if (this.user_.isGroupHasMember()) {
            Vector<String> userList = new Vector<String>();
            try {
                UserGroup userGroup = new UserGroup(this.user_.getSystem(), this.user_.getName());
                Enumeration users = userGroup.getMembers();
                while (users.hasMoreElements()) {
                    String userName = ((User)users.nextElement()).getUserProfileName();
                    userList.addElement(userName);
                }
            }
            catch (Exception err) {
                Trace.log(2, "error when retrieve members : " + err);
                this.errorEventSupport_.fireError(err);
            }
            JList list = new JList(userList);
            list.setBackground(Color.lightGray);
            VUtilities.constrain(new JLabel(groupMembersText_), list, panel, layout, row++);
        }
        return panel;
    }

    private Component getInternationalTab() {
        int i;
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(languageIDText_, this.user_.getLanguageID(), panel, layout, row++);
        VUtilities.constrain(countryIDText_, this.user_.getCountryID(), panel, layout, row++);
        int id = this.user_.getCCSID();
        String idStr = id == -2 ? "QCCSID" : Integer.toString(id);
        VUtilities.constrain(codedCharacterSetIDText_, idStr, panel, layout, row++);
        VUtilities.constrain(localePathNameText_, this.user_.getLocalePathName(), panel, layout, row++);
        VUtilities.constrain(new JLabel(localeJobAttributesText_), panel, layout, row++);
        String[] localJobAttributes = this.user_.getLocaleJobAttributes();
        JRadioButton[] radioButton = new JRadioButton[3];
        JCheckBox[] checkBox = new JCheckBox[6];
        boolean[] radio = new boolean[]{false, false, false};
        boolean[] check = new boolean[]{false, false, false, false, false, false};
        if (this.searchArray(localJobAttributes, "*NONE")) {
            radio[0] = true;
        } else if (this.searchArray(localJobAttributes, "*SYSVAL")) {
            radio[1] = true;
        } else {
            radio[2] = true;
        }
        String[] localJobAttributesStr = new String[]{"*NONE", "*SYSVAL", "CUSTOM", "*CCSID", "*DATFMT", "*DATSEP", "*DECFMT", "*SRTSEQ", "*TIMSEP"};
        for (i = 0; i < 6; ++i) {
            if (!this.searchArray(localJobAttributes, localJobAttributesStr[i + 3])) continue;
            check[i] = true;
        }
        for (i = 0; i < 3; ++i) {
            radioButton[i] = new JRadioButton(localJobAttributesStr[i], radio[i]);
            radioButton[i].setEnabled(false);
        }
        for (i = 0; i < 2; ++i) {
            VUtilities.constrain(radioButton[i], panel, layout, 1, row++, 1, 1);
        }
        for (i = 0; i < 6; ++i) {
            checkBox[i] = new JCheckBox(localJobAttributesStr[i + 3], check[i]);
            checkBox[i].setEnabled(false);
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                VUtilities.constrain(checkBox[i * 3 + j], panel, layout, j + 1, row, 1, 1);
            }
            ++row;
        }
        return panel;
    }

    private Component getOtherTab() {
        int i;
        int i2;
        JPanel otherTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        otherTab.setLayout(layout);
        otherTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(ownerText_, this.user_.getOwner(), otherTab, layout, row++);
        VUtilities.constrain(objectAuditingValueText_, this.user_.getObjectAuditingValue(), otherTab, layout, row++);
        VUtilities.constrain(specialEnvironmentText_, this.user_.getSpecialEnvironment(), otherTab, layout, row++);
        String str = this.user_.getSortSequenceTable();
        VUtilities.constrain(sortSequeneceTableText_, str, otherTab, layout, row++);
        int number = this.user_.getSupplementalGroupsNumber();
        String suplgrp = "";
        suplgrp = number == 0 ? "*NONE" : "" + number;
        VUtilities.constrain(supplementalGroupsNumberText_, suplgrp, otherTab, layout, row++);
        if (number > 0) {
            String[] libl = this.user_.getSupplementalGroups();
            JList<String> list = new JList<String>(libl);
            JScrollPane scroll = new JScrollPane(list);
            int height = Math.max(1, libl.length);
            scroll.setSize(120, 20 * height);
            VUtilities.constrain(new JLabel(supplementalGroupsText_), list, otherTab, layout, row++);
        }
        String[] levelStr = this.user_.getUserActionAuditLevel();
        JCheckBox[] levelCheckBox = new JCheckBox[13];
        boolean[] b = new boolean[13];
        for (int i3 = 0; i3 < 13; ++i3) {
            b[i3] = false;
        }
        String[] checkStr = new String[]{"*CMD", "*CREATE", "*DELETE", "*JOBDTA", "*OBJMGT", "*OFCSRV", "*OPTICAL", "*PGMADP", "*SAVRST", "*SECURITY", "*SERVICE", "*SPLFDTA", "*SYSMGT"};
        for (i2 = 0; i2 < 13; ++i2) {
            if (!this.searchArray(levelStr, checkStr[i2])) continue;
            b[i2] = true;
        }
        for (i2 = 0; i2 < 13; ++i2) {
            levelCheckBox[i2] = new JCheckBox(checkStr[i2], b[i2]);
            levelCheckBox[i2].setEnabled(false);
        }
        VUtilities.constrain(new JLabel(userActionAuditLevelText_), otherTab, layout, 0, row++, 1, 1);
        for (i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 3; ++j) {
                VUtilities.constrain(levelCheckBox[i2 * 3 + j], otherTab, layout, j + 1, row, 1, 1);
            }
            ++row;
        }
        VUtilities.constrain(levelCheckBox[12], otherTab, layout, 1, row++, 1, 1);
        String[] autStr = this.user_.getSpecialAuthority();
        JCheckBox[] autCheckBox = new JCheckBox[8];
        for (int i4 = 0; i4 < 8; ++i4) {
            b[i4] = false;
        }
        String[] autCheckStr = new String[]{"*ALLOBJ", "*AUDIT", "*IOSYSCFG", "*JOBCTL", "*SAVSYS", "*SECADM", "*SERVICE", "*SPLCTL"};
        for (i = 0; i < 8; ++i) {
            if (!this.searchArray(autStr, autCheckStr[i])) continue;
            b[i] = true;
        }
        for (i = 0; i < 8; ++i) {
            autCheckBox[i] = new JCheckBox(autCheckStr[i], b[i]);
            autCheckBox[i].setEnabled(false);
        }
        VUtilities.constrain(new JLabel(specialAuthorityText_), otherTab, layout, 0, row++, 1, 1);
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                VUtilities.constrain(autCheckBox[i * 3 + j], otherTab, layout, j + 1, row, 1, 1);
            }
            ++row;
        }
        VUtilities.constrain(autCheckBox[6], otherTab, layout, 1, row, 1, 1);
        VUtilities.constrain(autCheckBox[7], otherTab, layout, 2, row++, 1, 1);
        return otherTab;
    }

    private Component getOutputTab() {
        JPanel outputTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        outputTab.setLayout(layout);
        outputTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(printDeviceText_, this.user_.getPrintDevice(), outputTab, layout, row++);
        String fullPathName = this.user_.getOutputQueue();
        VUtilities.constrain(outputQueueText_, fullPathName, outputTab, layout, row++);
        fullPathName = this.user_.getMessageQueue();
        VUtilities.constrain(messageQueueText_, fullPathName, outputTab, layout, row++);
        VUtilities.constrain(messageDeliveryText_, this.user_.getMessageQueueDeliveryMethod(), outputTab, layout, row++);
        VUtilities.constrain(messageSeverityLevelText_, Integer.toString(this.user_.getMessageQueueSeverity()), outputTab, layout, row++);
        return outputTab;
    }

    private Component getSecurityTab() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        String pwdexpitv = "";
        int days = this.user_.getPasswordExpirationInterval();
        pwdexpitv = days == 0 ? "*SYSVAL" : (days == -1 ? "*NOMAX" : "" + days);
        VUtilities.constrain(passwordExpirationIntervalText_, pwdexpitv, panel, layout, row++);
        Date date = this.user_.getPasswordExpireDate();
        String dateTimeString = "NONE";
        if (date != null) {
            dateTimeString = dateFormat_.format(date) + " " + timeFormat_.format(date);
        }
        VUtilities.constrain(passwordExpireDateText_, dateTimeString, panel, layout, row++);
        VUtilities.constrain(daysUntilPasswordExpireText_, Integer.toString(this.user_.getDaysUntilPasswordExpire()), panel, layout, row++);
        date = this.user_.getPasswordLastChangedDate();
        dateTimeString = date != null ? dateFormat_.format(date) + " " + timeFormat_.format(date) : "NONE";
        VUtilities.constrain(passwordLastChangedDateText_, dateTimeString, panel, layout, row++);
        date = this.user_.getPreviousSignedOnDate();
        dateTimeString = date != null ? dateFormat_.format(date) + " " + timeFormat_.format(date) : "NONE";
        VUtilities.constrain(previousSignedOnDateText_, dateTimeString, panel, layout, row++);
        VUtilities.constrain(signedOnAttemptsNotValidText_, Integer.toString(this.user_.getSignedOnAttemptsNotValid()), panel, layout, row++);
        String value = falseText_;
        if (this.user_.isNoPassword()) {
            value = trueText_;
        }
        VUtilities.constrain(isNoPasswordText_, value, panel, layout, row++);
        value = falseText_;
        if (this.user_.isPasswordSetExpire()) {
            value = trueText_;
        }
        VUtilities.constrain(isPasswordSetExpireText_, value, panel, layout, row++);
        value = falseText_;
        if (this.user_.isWithDigitalCertificates()) {
            value = trueText_;
        }
        VUtilities.constrain(isWithDigitalCertificatesText_, value, panel, layout, row++);
        return panel;
    }

    private Component getSessionStartupTab() {
        JPanel sessionStartupTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        sessionStartupTab.setLayout(layout);
        sessionStartupTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        String string = this.user_.getInitialProgram();
        VUtilities.constrain(initialProgramText_, string, sessionStartupTab, layout, row++);
        string = this.user_.getInitialMenu();
        VUtilities.constrain(initialMenuText_, string, sessionStartupTab, layout, row++);
        VUtilities.constrain(displaySignOnInformationText_, this.user_.getDisplaySignOnInformation(), sessionStartupTab, layout, row++);
        VUtilities.constrain(limitDeviceSessionsText_, this.user_.getLimitDeviceSessions(), sessionStartupTab, layout, row++);
        return sessionStartupTab;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    private boolean searchArray(String[] array, String check) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(check)) continue;
            return true;
        }
        return false;
    }
}

