/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VJavaApplicationCall;

class VJavaGetResult
implements Runnable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VJavaApplicationCall vJavaAppCall_;
    private JavaApplicationCall javaAppCall_;
    private boolean javaAppRunOver_ = false;
    private Thread runAppThread_;
    private Thread outputThread_;
    private Thread errorThread_;
    long readCounter_ = 0L;

    public VJavaGetResult(VJavaApplicationCall vJavaAppCall) {
        this.vJavaAppCall_ = vJavaAppCall;
        this.javaAppCall_ = this.vJavaAppCall_.getJavaApplicationCall();
    }

    private void delay() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.runAppThread_ = null;
        this.errorThread_ = null;
        this.outputThread_ = null;
        super.finalize();
    }

    public void play() {
        this.javaAppRunOver_ = false;
        this.outputThread_ = new Thread(this);
        this.errorThread_ = new Thread(this);
        this.outputThread_.start();
        this.errorThread_.start();
        this.runAppThread_ = new Thread(this);
        this.runAppThread_.start();
    }

    public void run() {
        if (Thread.currentThread() == this.runAppThread_) {
            this.vJavaAppCall_.setJavaAppRunOver(false);
            try {
                this.javaAppCall_.run();
            }
            catch (Exception e) {
                Trace.log(2, e.toString());
                this.vJavaAppCall_.appendOutput(e.toString());
            }
            AS400Message[] messageList = this.javaAppCall_.getMessageList();
            if (messageList != null && messageList.length > 0) {
                for (int i = 0; i < messageList.length; ++i) {
                    this.vJavaAppCall_.appendOutput(messageList[i].getID());
                    this.vJavaAppCall_.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_MESSAGE_SEP"));
                    this.vJavaAppCall_.appendOutput(messageList[i].getText() + "\n");
                }
            }
            long localCounter = this.readCounter_;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            while (localCounter < this.readCounter_) {
                localCounter = this.readCounter_;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
            }
            this.vJavaAppCall_.setJavaAppRunOver(true);
            this.javaAppRunOver_ = true;
            this.vJavaAppCall_.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else if (Thread.currentThread() == this.outputThread_) {
            while (!this.javaAppRunOver_) {
                String receiveStr;
                while ((receiveStr = this.javaAppCall_.getStandardOutString()) != null) {
                    ++this.readCounter_;
                    this.vJavaAppCall_.appendOutput(receiveStr + "\n");
                }
                this.delay();
            }
        } else {
            String errorStr = null;
            while (!this.javaAppRunOver_) {
                while ((errorStr = this.javaAppCall_.getStandardErrorString()) != null) {
                    ++this.readCounter_;
                    this.vJavaAppCall_.appendOutput(errorStr + "\n");
                }
                this.delay();
            }
        }
    }
}

