/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VResourcePropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Icon;

public class VJobLogMessage
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("JOB_LOG_MESSAGE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VMessage16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VMessage32.gif", description_);
    private RQueuedMessage message_ = null;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object DATE_PROPERTY = "Date";
    public static final Object FROM_PROGRAM_PROPERTY = "From program";
    public static final Object ID_PROPERTY = "ID";
    public static final Object SEVERITY_PROPERTY = "Severity";
    public static final Object TEXT_PROPERTY = "Text";
    public static final Object TYPE_PROPERTY = "Type";
    private static final Hashtable map_ = new Hashtable();
    private static ResourceProperties properties_;

    VJobLogMessage(RQueuedMessage message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message_ = message;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public VAction[] getActions() {
        return null;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        Object propertyValue;
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (propertyIdentifier == null) {
            return null;
        }
        Object attributeID = map_.get(propertyIdentifier);
        if (attributeID == null) {
            return null;
        }
        try {
            propertyValue = this.message_.getAttributeValue(attributeID);
        }
        catch (ResourceException e) {
            this.errorEventSupport_.fireError(e);
            return null;
        }
        if (propertyIdentifier == TYPE_PROPERTY) {
            return MessageUtilities.getTypeText((Integer)propertyValue);
        }
        return propertyValue;
    }

    public String getText() {
        try {
            return (String)this.message_.getAttributeValue("MESSAGE_ID");
        }
        catch (ResourceException e) {
            return "";
        }
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.propertiesPane_ = new VResourcePropertiesPane(this, this.message_, properties_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void load() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public String toString() {
        return this.getText();
    }

    static {
        map_.put(DATE_PROPERTY, "DATE_SENT");
        map_.put(FROM_PROGRAM_PROPERTY, "SENDING_PROGRAM_NAME");
        map_.put(ID_PROPERTY, "MESSAGE_ID");
        map_.put(SEVERITY_PROPERTY, "MESSAGE_SEVERITY");
        map_.put(TEXT_PROPERTY, "MESSAGE_TEXT");
        map_.put(TYPE_PROPERTY, "MESSAGE_TYPE");
        properties_ = null;
        properties_ = new ResourceProperties();
        properties_.addProperties(new Object[]{"MESSAGE_TEXT", "MESSAGE_HELP", "MESSAGE_SEVERITY", "MESSAGE_TYPE", "DATE_SENT", "SENDING_PROGRAM_NAME"});
    }
}

