/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.JavaApplicationCall;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.RunJavaApplicationThread;

public class RunJavaApplication {
    private static JavaApplicationCall runMain_ = null;
    private static ResourceBundle resources_ = ResourceBundle.getBundle("utilities.UTMRI");
    private static RunJavaApplicationThread errorThread_ = null;
    private static RunJavaApplicationThread inputThread_ = null;
    private static RunJavaApplicationThread outputThread_ = null;
    private static RunJavaApplicationThread runApplication_ = null;
    private static Vector inputLines_ = new Vector();
    private static String classpath_ = "";
    private static String[] option_ = new String[]{"*NONE"};

    public static void main(String[] parameters) {
        Object rja = null;
        String inputString = null;
        AS400 as400 = new AS400();
        try {
            if (parameters.length > 0) {
                as400.setSystemName(parameters[0]);
            }
            if (parameters.length > 1) {
                as400.setUserId(parameters[1]);
            }
            if (parameters.length > 2) {
                as400.setPassword(parameters[2]);
            }
            runMain_ = new JavaApplicationCall(as400);
            inputThread_ = new RunJavaApplicationThread(runMain_, 3);
            inputThread_.start();
            outputThread_ = new RunJavaApplicationThread(runMain_, 2);
            outputThread_.start();
            errorThread_ = new RunJavaApplicationThread(runMain_, 4);
            errorThread_.start();
            runApplication_ = new RunJavaApplicationThread(runMain_, 1);
            System.out.print(resources_.getString("REMOTE_PROMPT"));
            while (true) {
                String is = null;
                if (inputLines_.size() > 0) {
                    is = (String)inputLines_.elementAt(0);
                    inputLines_.removeElementAt(0);
                }
                if (is != null) {
                    if (!runApplication_.isAlive()) {
                        inputString = is.toUpperCase().trim();
                        if (inputString.equals("QUIT") || inputString.equals("Q")) {
                            System.exit(0);
                        } else if (inputString.startsWith("JAVA ")) {
                            if (RunJavaApplication.preProcessJavaCommand(runMain_, is.substring(4))) {
                                runApplication_ = new RunJavaApplicationThread(runMain_, 1);
                                runApplication_.start();
                            } else {
                                RunJavaApplication.showPrompt();
                            }
                        } else if (inputString.startsWith("SET ")) {
                            String pair = is.substring("SET ".length());
                            String property = null;
                            String value = null;
                            int index = pair.indexOf("=");
                            if (index > 0 && !pair.endsWith("=")) {
                                property = pair.substring(0, index);
                                value = pair.substring(index + 1);
                                property = property.trim();
                                RunJavaApplication.setProperty(runMain_, property.toUpperCase(), value);
                            } else {
                                System.out.println(resources_.getString("REMOTE_ERR_SET"));
                            }
                            RunJavaApplication.showPrompt();
                        } else if (inputString.equals("HELP") || inputString.equals("?") || inputString.equals("H")) {
                            RunJavaApplication.showHelp();
                            RunJavaApplication.showPrompt();
                        } else if (inputString.equals("D")) {
                            RunJavaApplication.displayProperties();
                            RunJavaApplication.showPrompt();
                        } else {
                            if (!inputString.equals("")) {
                                if (inputString.equals("JAVA")) {
                                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                                } else if (inputString.equals("SET")) {
                                    RunJavaApplication.displayProperties();
                                } else {
                                    System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_BAD_COMMAND"));
                                }
                            }
                            RunJavaApplication.showPrompt();
                        }
                    } else {
                        runMain_.sendStandardInString(is);
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private static void displayProperties() {
        StringBuffer optionString = new StringBuffer();
        for (int i = 0; i < option_.length; ++i) {
            optionString.append(option_[i]);
            optionString.append(" ");
        }
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE1"));
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE2") + runMain_.getSecurityCheckLevel());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE3") + classpath_);
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE4") + runMain_.getGarbageCollectionFrequency());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE5") + runMain_.getGarbageCollectionInitialSize());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE6") + runMain_.getGarbageCollectionMaximumSize());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE7") + runMain_.getGarbageCollectionPriority());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE8") + runMain_.getInterpret());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE9") + runMain_.getOptimization());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE10") + optionString.toString());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE11") + runMain_.getDefaultPort());
        System.out.println("   " + RunJavaApplication.getMRIResource().getString("REMOTE_D_LINE12") + runMain_.isFindPort());
    }

    private static ResourceBundle getMRIResource() {
        if (resources_ == null) {
            resources_ = ResourceBundle.getBundle("utilities.UTMRI");
        }
        return resources_;
    }

    protected static Vector getInputBuffer() {
        return inputLines_;
    }

    private static boolean preProcessJavaCommand(JavaApplicationCall jac, String inputStr) {
        int indexOfClass;
        StringTokenizer strToken = new StringTokenizer(inputStr.trim(), " ");
        int paramNum = strToken.countTokens();
        Vector<String> command = new Vector<String>();
        for (int i = 0; i < paramNum; ++i) {
            command.addElement(strToken.nextToken());
        }
        boolean classExist = false;
        for (indexOfClass = 0; indexOfClass < paramNum; ++indexOfClass) {
            String str = (String)command.elementAt(indexOfClass);
            if (str.indexOf("-") != -1) continue;
            classExist = true;
            break;
        }
        if (!classExist) {
            System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
            return false;
        }
        int numOfClasspath = 0;
        int numOfVerbose = 0;
        boolean numOfProperty = false;
        boolean tempClasspathExist = false;
        boolean verboseExist = false;
        Properties properties = new Properties();
        for (int i = 0; i < indexOfClass; ++i) {
            String env = (String)command.elementAt(0);
            command.removeElementAt(0);
            String upperEnv = env.toUpperCase();
            if (upperEnv.indexOf("-CLASSPATH=") == 0) {
                if (++numOfClasspath > 1) {
                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                    return false;
                }
                try {
                    int index = env.indexOf("=");
                    String path = env.substring(index);
                    if (path.endsWith("=") || index < 0) {
                        throw new Exception("classPath");
                    }
                    path = path.replace('=', ' ') + " ";
                    jac.setClassPath(path.trim());
                    tempClasspathExist = true;
                    continue;
                }
                catch (Exception e) {
                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                    return false;
                }
            }
            if (upperEnv.indexOf("-VERBOSE") == 0) {
                if (++numOfVerbose > 1) {
                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                    return false;
                }
                String[] curOption = jac.getOptions();
                boolean alreadyExist = false;
                for (int j = 0; j < curOption.length; ++j) {
                    if (!curOption[j].equals("*VERBOSE")) continue;
                    alreadyExist = true;
                    verboseExist = true;
                    break;
                }
                try {
                    if (alreadyExist) continue;
                    String[] newOpt = new String[curOption.length + 1];
                    for (int optidx = 0; optidx < curOption.length; ++optidx) {
                        newOpt[optidx] = curOption[optidx];
                    }
                    newOpt[newOpt.length - 1] = "*VERBOSE";
                    jac.setOptions(newOpt);
                    verboseExist = true;
                    continue;
                }
                catch (PropertyVetoException e) {
                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                    return false;
                }
            }
            if (upperEnv.indexOf("-D") == 0) {
                try {
                    int len = "-D".length();
                    String prop = env.substring(len);
                    int index = prop.indexOf("=");
                    if (prop.endsWith("=") || index <= 0) {
                        throw new Exception("properties");
                    }
                    properties.put(prop.substring(0, index), prop.substring(index + 1));
                    continue;
                }
                catch (Exception e) {
                    System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
                    return false;
                }
            }
            System.out.println(resources_.getString("REMOTE_ERR_JAVA"));
            return false;
        }
        String application = (String)command.elementAt(0);
        command.removeElementAt(0);
        try {
            if (!tempClasspathExist) {
                jac.setClassPath(classpath_);
            }
            if (!verboseExist) {
                jac.setOptions(option_);
            }
            if (!properties.isEmpty()) {
                jac.setProperties(properties);
            }
            jac.setJavaApplication(application);
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<String> appParm = new Vector<String>();
        for (int parmNum = 0; parmNum < command.size(); ++parmNum) {
            appParm.addElement((String)command.elementAt(parmNum));
        }
        try {
            if (appParm.size() > 0) {
                String[] parmArray = new String[appParm.size()];
                for (int i = 0; i < appParm.size(); ++i) {
                    parmArray[i] = (String)appParm.elementAt(i);
                }
                jac.setParameters(parmArray);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    private static void setProperty(JavaApplicationCall jac, String property, String value) {
        try {
            value = value.trim();
            if (value.length() == 0) {
                System.out.println(resources_.getString("REMOTE_ERR_SET"));
            } else if (property.equals("CLASSPATH")) {
                jac.setClassPath(value);
                classpath_ = value;
            } else if (property.equals("SECURITYCHECKLEVEL")) {
                jac.setSecurityCheckLevel(value);
            } else if (property.equals("OPTION")) {
                StringTokenizer st = new StringTokenizer(value.trim(), " ");
                String[] options = new String[st.countTokens()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = st.nextToken();
                }
                jac.setOptions(options);
                option_ = options;
            } else if (property.equals("INTERPRET")) {
                jac.setInterpret(value);
            } else if (property.equals("GARBAGECOLLECTIONINITIALSIZE")) {
                Integer val = new Integer(value);
                jac.setGarbageCollectionInitialSize(val);
            } else if (property.equals("GARBAGECOLLECTIONMAXIMUMSIZE")) {
                jac.setGarbageCollectionMaximumSize(value);
            } else if (property.equals("GARBAGECOLLECTIONFREQUENCY")) {
                Integer val = new Integer(value);
                jac.setGarbageCollectionFrequency(val);
            } else if (property.equals("GARBAGECOLLECTIONPRIORITY")) {
                Integer val = new Integer(value);
                jac.setGarbageCollectionPriority(val);
            } else if (property.equals("OPTIMIZE")) {
                jac.setOptimization(value);
            } else if (property.equals("DEFAULTPORT")) {
                Integer val = new Integer(value);
                jac.setDefaultPort(val);
            } else if (property.equals("FINDPORT")) {
                String val = value.toUpperCase();
                if (val.equals("TRUE")) {
                    jac.setFindPort(true);
                } else if (val.equals("FALSE")) {
                    jac.setFindPort(false);
                } else {
                    System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_PORT_VALUE_ERROR"));
                }
            } else {
                System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_SET_PROPERTY_1") + " " + property + " " + RunJavaApplication.getMRIResource().getString("REMOTE_SET_PROPERTY_2"));
            }
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    private static void showHelp() {
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE1"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE2"));
        System.out.println("       " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE3"));
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE4"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE5"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE6"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE7"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE8"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE9"));
        System.out.println("  " + RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE10"));
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE11"));
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE12"));
        System.out.println(RunJavaApplication.getMRIResource().getString("REMOTE_HELP_LINE13"));
    }

    private static void showPrompt() {
        System.out.println();
        System.out.print(resources_.getString("REMOTE_PROMPT"));
    }
}

