/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import utilities.RunJavaApplication;

class RunJavaApplicationThread
extends Thread {
    static final int RUN_APPLICATION = 1;
    static final int OUTPUT = 2;
    static final int INPUT = 3;
    static final int ERROR = 4;
    private static ResourceBundle resources_ = ResourceBundle.getBundle("utilities.UTMRI");
    private int threadID_ = 0;
    private JavaApplicationCall runMain_ = null;

    RunJavaApplicationThread(JavaApplicationCall jac, int whichThread) {
        this.runMain_ = jac;
        this.threadID_ = whichThread;
    }

    public void run() {
        if (this.threadID_ == 1) {
            System.out.println(resources_.getString("REMOTE_START_PROGRAM") + " " + this.runMain_.getJavaApplication() + "\n");
            boolean success = false;
            try {
                success = this.runMain_.run();
            }
            catch (Exception e) {
                System.out.println(resources_.getString("REMOTE_CALL_JAVA_ERROR"));
                System.out.println(e.toString());
            }
            AS400Message[] messageList = this.runMain_.getMessageList();
            if (messageList != null && messageList.length > 0) {
                for (int i = 0; i < messageList.length; ++i) {
                    System.out.print(messageList[i].getID());
                    System.out.print(resources_.getString("REMOTE_MESSAGE_FROM_COMMAND_SEP"));
                    System.out.println(messageList[i].getText());
                }
            }
        } else {
            if (this.threadID_ == 2) {
                while (true) {
                    String so = null;
                    while ((so = this.runMain_.getStandardOutString()) != null) {
                        System.out.println(so);
                    }
                    this.delay();
                }
            }
            if (this.threadID_ == 4) {
                while (true) {
                    String se = null;
                    while ((se = this.runMain_.getStandardErrorString()) != null) {
                        System.out.println(se);
                    }
                    this.delay();
                }
            }
            InputStreamReader reader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while (true) {
                try {
                    String data = bufferedReader.readLine();
                    if (data != null) {
                        RunJavaApplication.getInputBuffer().addElement(data);
                    }
                }
                catch (Exception e) {
                    Trace.log(2, e);
                }
                this.delay();
            }
        }
        System.out.println();
        System.out.print(resources_.getString("REMOTE_PROMPT"));
    }

    private void delay() {
        try {
            RunJavaApplicationThread.sleep(100L);
        }
        catch (Exception e) {
            Trace.log(2, e);
        }
    }
}

