/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMString;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;

public class AsynchronousSubscriber {
    private boolean quitFlag = false;
    protected ServerSocket myServerSocket = null;

    protected AsynchronousSubscriber() {
    }

    public AsynchronousSubscriber(InetAddress inetaddress, int port, int backlog, int timeout) throws IOException, UnknownHostException {
        this.myServerSocket = ServerSocketFactory.getDefault().createServerSocket(port, backlog, inetaddress == null ? InetAddress.getLocalHost() : inetaddress);
        this.setTimeout(timeout);
        System.out.println("My server socket is:   " + this.myServerSocket);
        System.out.println("My inet address  is:   " + this.myServerSocket.getInetAddress() + ":" + this.myServerSocket.getLocalPort());
        System.out.println("My backlog was set to: " + backlog);
        System.out.println("My socket  is bound:   " + this.myServerSocket.isBound());
    }

    protected ParameterArray composeOutputArray() {
        ParameterArray parameterArray = new ParameterArray();
        parameterArray.add(new VSMInt4(-1, "userid_length"));
        parameterArray.add(new VSMString("", "userid"));
        parameterArray.add(new VSMInt4(-1, "user_word_length"));
        parameterArray.add(new VSMString("", "user_word"));
        parameterArray.add(new VSMInt4(-1, "sub_data_length"));
        parameterArray.add(new VSMString("", "sub_data"));
        return parameterArray;
    }

    ParameterArray readNotification() throws IOException, VSMException {
        ParameterArray pa = null;
        try {
            Socket socket = this.myServerSocket.accept();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            pa = this.composeOutputArray();
            pa.readAll(din);
            socket.close();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return pa;
    }

    public void subscriptionLoop(PrintStream printstream) throws IOException, VSMException {
        ParameterArray pa = null;
        while (!this.quitFlag) {
            pa = this.readNotification();
            if (pa != null) {
                printstream.println(pa.prettyPrintParams());
                continue;
            }
            System.out.println("accept timeout");
        }
    }

    public void setTimeout(int timeout) throws SocketException {
        if (this.myServerSocket != null) {
            this.myServerSocket.setSoTimeout(timeout);
        }
    }

    public void quit(boolean quitOrNot) {
        this.quitFlag = quitOrNot;
    }

    public static void main(String[] argv) throws IOException, UnknownHostException, VSMException {
        if (argv.length != 4) {
            System.out.println("usage: AsynchronousSubscribe inetaddress port backlog timeout");
            System.exit(1);
        }
        InetAddress inetaddr = null;
        inetaddr = argv[0].equals("") ? InetAddress.getLocalHost() : InetAddress.getByName(argv[0]);
        int port = new Integer(argv[1]);
        int backlog = new Integer(argv[2]);
        int timeout = new Integer(argv[3]);
        System.out.println("Creating AsynchronousSubscriber on " + inetaddr + ":" + port + " with backlog of " + backlog + " with timeout of " + timeout + ".");
        AsynchronousSubscriber as = new AsynchronousSubscriber(inetaddr, port, backlog, timeout);
        as.subscriptionLoop(System.out);
    }
}

