/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMParm;
import com.softwoehr.pigiron.access.VSMStruct;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class CountedArray
extends VSMStruct
implements VSMParm {
    private Integer lengthCount;

    public Integer getLengthCount() {
        return this.lengthCount;
    }

    public void setLengthCount(Integer lengthCount) {
        this.lengthCount = lengthCount;
    }

    @Override
    public int paramLength() {
        int result = 0;
        if (this.getValue() != null) {
            result = super.paramLength() + 4;
        }
        return result;
    }

    public static CountedArray modelArray(VSMParm model, String formalName) {
        CountedArray result = new CountedArray();
        result.add(model);
        result.setFormalName(formalName);
        return result;
    }

    public CountedArray() {
    }

    public CountedArray(CountedArray value) {
        super(value);
        this.lengthCount = super.paramLength();
    }

    public CountedArray(CountedArray value, String formalName) {
        this(value);
        this.setFormalName(formalName);
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException, VSMException {
        VSMParm target;
        if (length < 4) {
            throw new VSMException("Remaining length shorter than size of CountedArray count word");
        }
        CountedArray v = new CountedArray();
        v.lengthCount = in.readInt();
        length -= 4;
        VSMParm model = (VSMParm)this.get(0);
        for (int remaining_array_length = v.lengthCount.intValue(); remaining_array_length > 0 && length > 0; length -= target.paramLength(), remaining_array_length -= target.paramLength()) {
            target = model.copyOf();
            target.read(in, length);
            v.add(target);
        }
        this.setValue(v);
    }

    @Override
    public VSMParm copyOf() {
        CountedArray bozo = new CountedArray();
        bozo.setFormalName(this.getFormalName());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            bozo.add(((VSMParm)it.next()).copyOf());
        }
        return bozo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VSMArray " + super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    static {
        FORMAL_TYPE = "array";
    }

    public class VSMArrayCountedStructCTORException
    extends VSMException {
        public VSMArrayCountedStructCTORException(String message) {
            super(message);
        }
    }
}

