/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CountedString
implements VSMParm {
    public static final String FORMAL_TYPE = "string";
    private String value;
    private String formalName;
    private Integer lengthCount;

    public CountedString() {
    }

    public CountedString(String value) {
        this();
        this.value = value;
        this.lengthCount = value == null ? 0 : value.length();
    }

    public CountedString(String value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public Integer getLengthCount() {
        return this.lengthCount;
    }

    public void setLengthCount(Integer lengthCount) {
        this.lengthCount = lengthCount;
    }

    @Override
    public int paramLength() {
        int result = 0;
        if (this.value != null) {
            result = this.value.length() + 4;
        }
        return result;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException, VSMException {
        if (length < 4) {
            throw new VSMException("Remaining length shorter than size of CountedString count word");
        }
        this.setLengthCount(in.readInt());
        byte[] bytes = new byte[this.getLengthCount().intValue()];
        in.readFully(bytes);
        this.setValue(new String(bytes));
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.getLengthCount());
        out.write(this.value.getBytes());
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new CountedString(this.getValue(), this.getFormalName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(this.getValue());
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") count:").append(this.getLengthCount()).append(" value: ").append(this.getValue());
        return sb.toString();
    }
}

