/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CountedStringZ
implements VSMParm {
    public static final String FORMAL_TYPE = "counted_z_string";
    private String value;
    private String formalName;
    private Integer lengthCount = 0;

    public CountedStringZ() {
    }

    public CountedStringZ(String value) {
        this();
        this.value = value;
        this.lengthCount = this.value == null ? 0 : value.length() + 1;
    }

    public CountedStringZ(String value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public Integer getLengthCount() {
        return this.lengthCount;
    }

    public void setLengthCount(Integer lengthCount) {
        this.lengthCount = lengthCount;
    }

    @Override
    public int paramLength() {
        return 4 + this.lengthCount;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException, VSMException {
        if (length < 4) {
            throw new VSMException("Remaining length shorter than size of CountedString count word");
        }
        this.setLengthCount(in.readInt());
        byte[] bytes = new byte[this.getLengthCount().intValue()];
        in.readFully(bytes);
        this.setValue(new String(bytes, 0, bytes.length - 1));
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.getLengthCount());
        if (this.value != null) {
            out.write(this.value.getBytes());
            out.write(0);
        }
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new CountedStringZ(this.getValue(), this.getFormalName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(this.getValue());
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") count:").append(this.getLengthCount()).append(" value: ").append(this.getValue());
        return sb.toString();
    }
}

