/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMParm;
import com.softwoehr.pigiron.access.VSMStruct;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class CountedStruct
extends VSMStruct {
    public CountedStruct(CountedStruct value, String formalName) {
        super(value, formalName);
    }

    public CountedStruct(CountedStruct value) {
        super(value);
    }

    public CountedStruct() {
    }

    @Override
    public VSMParm copyOf() {
        CountedStruct proto = new CountedStruct();
        proto.setFormalName(this.getFormalName());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            proto.add(((VSMParm)it.next()).copyOf());
        }
        return proto;
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(DataInputStream in, int length) throws IOException, VSMStruct.VSMStructStringReadException, VSMException {
        if (length < 4) throw new CountedStructStructReadException("CountedStruct named " + this.getFormalName() + " of type " + this.getFormalType() + "can't be read because remaining length is less than that of its count word.");
        if (this.size() != 2) throw new CountedStructStructReadException("CountedStruct named " + this.getFormalName() + " of type " + this.getFormalType() + "is missing a second (struct) element ergo appears unmodelled.");
        VSMParm purportedCountParm = (VSMParm)this.get(0);
        if (!(purportedCountParm instanceof VSMInt4)) {
            throw new CountedStructStructReadException("First element in counted struct named " + this.getFormalName() + " of type " + this.getFormalType() + " is not of type VMSInt4 so cannot be a count.");
        }
        purportedCountParm.read(in, 4);
        int structLength = ((VSMInt4)VSMInt4.class.cast(purportedCountParm)).getValue();
        if (structLength > (length -= 4)) {
            throw new CountedStructStructReadException("CountedStruct named " + this.getFormalName() + " of type " + this.getFormalType() + " had a purported length " + structLength + " greater than the remaining read length " + length + ".");
        }
        VSMStruct myStruct = (VSMStruct)VSMStruct.class.cast(this.get(1));
        myStruct.read(in, structLength);
    }

    public int getCountInt() {
        return ((VSMInt4)VSMInt4.class.cast(this.get(0))).getValue();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    static {
        FORMAL_TYPE = "counted_struct";
    }

    public class CountedStructStructReadException
    extends VSMException {
        public CountedStructStructReadException(String message) {
            super(message);
        }
    }
}

