/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMParm;
import com.softwoehr.pigiron.bizobj.VsmapiRC;
import com.softwoehr.pigiron.functions.VSMCall;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class ParameterArray
extends ArrayList<VSMParm> {
    public static final int SIZEOF_INT1 = 1;
    public static final int SIZEOF_INT4 = 4;
    public static final int SIZEOF_INT8 = 8;
    protected VSMCall function = null;

    protected ParameterArray() {
    }

    public ParameterArray(VSMCall function) {
        this.function = function;
    }

    public void setValue(ParameterArray value) {
        this.clear();
        if (value != null) {
            this.addAll(value);
        }
    }

    public VSMCall getFunction() {
        return this.function;
    }

    public VSMParm parameterNamed(String name) {
        VSMParm result = null;
        for (VSMParm v : this) {
            if (!v.getFormalName().equals(name)) continue;
            result = v;
            break;
        }
        return result;
    }

    public void writeParameterAt(int index, DataOutputStream out) throws IOException {
        VSMParm p = (VSMParm)this.get(index);
        p.write(out);
    }

    public long totalParameterLength() {
        long total = 0L;
        Iterator thisIterator = this.iterator();
        while (thisIterator.hasNext()) {
            total += (long)((VSMParm)thisIterator.next()).paramLength();
        }
        return total;
    }

    public void writeAll(DataOutputStream out) throws IOException {
        Iterator myIterator = this.iterator();
        while (myIterator.hasNext()) {
            ((VSMParm)myIterator.next()).write(out);
        }
        out.flush();
    }

    public void readAll(DataInputStream in) throws IOException, VSMException {
        VSMParm copyOfCurrentParm;
        ListIterator currentListIterator = this.listIterator();
        ParameterArray replacement = new ParameterArray();
        VSMInt4 request_id = (VSMInt4)VSMInt4.class.cast(((VSMParm)currentListIterator.next()).copyOf());
        request_id.read(in, -1);
        replacement.add(request_id);
        VSMInt4 output_length = (VSMInt4)VSMInt4.class.cast(((VSMParm)currentListIterator.next()).copyOf());
        output_length.read(in, -1);
        replacement.add(output_length);
        for (int length_left = output_length.getValue(); currentListIterator.hasNext() && length_left > 0; length_left -= copyOfCurrentParm.paramLength()) {
            copyOfCurrentParm = ((VSMParm)currentListIterator.next()).copyOf();
            copyOfCurrentParm.read(in, length_left);
            replacement.add(copyOfCurrentParm);
        }
        this.setValue(replacement);
    }

    public String prettyPrintAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prettyPrintRCAndReason());
        sb.append(this.prettyPrintParams());
        return sb.toString();
    }

    public String prettyPrintParams() {
        StringBuilder sb = new StringBuilder();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            sb.append(((VSMParm)i.next()).prettyPrint());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String prettyPrintRCAndReason() {
        String result;
        VSMParm rc = this.parameterNamed("return_code");
        VSMParm reason = this.parameterNamed("reason_code");
        if (rc == null) {
            result = "No parameter named return_code found in " + this;
        } else if (reason == null) {
            result = "No parameter named reason_code found in " + this;
        } else {
            VSMInt4 rc_int4 = (VSMInt4)VSMInt4.class.cast(rc);
            VSMInt4 reason_int4 = (VSMInt4)VSMInt4.class.cast(reason);
            result = VsmapiRC.prettyPrint(rc_int4.getValue(), reason_int4.getValue(), this.getFunction()) + "\n";
        }
        return result;
    }

    public class ParameterArrayReadAllException
    extends VSMException {
        public ParameterArrayReadAllException(String message) {
            super(message);
        }
    }
}

