/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.Connection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketConnection
implements Connection {
    protected DataInputStream inputStream;
    protected DataOutputStream outputStream;
    protected Socket socket;
    protected String hostname;
    protected int port;

    public SocketConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public DataInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public DataOutputStream getOutputStream() {
        return this.outputStream;
    }

    protected void setInputStream(DataInputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected void setOutputStream(DataOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void connect() throws UnknownHostException, IOException {
        this.setSocket(new Socket(this.hostname, this.port));
        this.setOutputStream(new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream())));
        this.setInputStream(new DataInputStream(new BufferedInputStream(this.socket.getInputStream())));
    }

    @Override
    public void disconnect() {
        try {
            this.getOutputStream().close();
        }
        catch (IOException ex) {
            Logger.getLogger(SocketConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.getInputStream().close();
        }
        catch (IOException ex) {
            Logger.getLogger(SocketConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.getSocket().close();
        }
        catch (IOException ex) {
            Logger.getLogger(SocketConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean isConnected() {
        return this.getSocket().isConnected();
    }
}

