/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VSMAsciiZ
implements VSMParm {
    public static final String FORMAL_TYPE = "asciiz";
    private String value;
    private String formalName;

    public VSMAsciiZ() {
    }

    public VSMAsciiZ(String value) {
        this();
        this.setValue(value);
    }

    public VSMAsciiZ(String value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public static String stripTerminated(String string) {
        if (string != null && string.indexOf(0) > 0) {
            string = string.substring(0, string.indexOf(0));
        }
        return string;
    }

    public static String terminate(String string) {
        if (string != null) {
            string = string + '\u0000';
        }
        return string;
    }

    public String getValue() {
        return VSMAsciiZ.stripTerminated(this.value);
    }

    public final void setValue(String value) {
        this.value = value == null ? value : VSMAsciiZ.terminate(VSMAsciiZ.stripTerminated(value));
    }

    @Override
    public int paramLength() {
        int result = 0;
        if (this.value != null) {
            result = this.value.length();
        }
        return result;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = in.readChar();
            result.append(c);
            if (c == '\u0000') break;
        }
        this.setValue(result.toString());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.value.getBytes());
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new VSMAsciiZ(this.getValue(), this.getFormalName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(VSMAsciiZ.stripTerminated(this.getValue()));
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") ").append(VSMAsciiZ.stripTerminated(this.getValue()));
        return sb.toString();
    }
}

