/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMInt;
import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VSMInt4
implements VSMParm,
VSMInt {
    private int value = -1;
    private String formalName;
    public static final String FORMAL_TYPE = "int4";

    public VSMInt4() {
    }

    public VSMInt4(int value) {
        this();
        this.value = value;
    }

    public VSMInt4(int value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public final void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int paramLength() {
        return 4;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException {
        this.setValue(in.readInt());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new VSMInt4(this.getValue(), this.getFormalName());
    }

    @Override
    public long getLongValue() {
        return new Long(this.getValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(this.value);
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") ").append(this.getValue());
        return sb.toString();
    }
}

