/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMInt;
import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VSMInt8
implements VSMParm,
VSMInt {
    private long value = -1L;
    private String formalName;
    public static final String FORMAL_TYPE = "int8";

    public VSMInt8(long value) {
        this.value = value;
    }

    public VSMInt8(long value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public final void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int paramLength() {
        return 8;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException {
        this.setValue(in.readLong());
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public long getLongValue() {
        return this.getValue();
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new VSMInt8(this.value, this.formalName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(this.value);
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") ").append(this.getValue());
        return sb.toString();
    }
}

