/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VSMString
implements VSMParm {
    public static final String FORMAL_TYPE = "string";
    private String value;
    private String formalName;

    public VSMString() {
    }

    public VSMString(String value) {
        this();
        this.value = value;
    }

    public VSMString(VSMString vSMString) {
        this(vSMString.getValue(), vSMString.getFormalName());
    }

    public VSMString(String value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    @Override
    public int paramLength() {
        int result = 0;
        if (this.value != null) {
            result = this.value.length();
        }
        return result;
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException {
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        this.setValue(new String(bytes));
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.value.getBytes());
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public VSMParm copyOf() {
        return new VSMString(this.getValue(), this.getFormalName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        sb.append(" Value == ").append(this.getValue());
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append(") ").append(this.getValue());
        return sb.toString();
    }
}

