/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.access;

import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class VSMStruct
extends ArrayList<VSMParm>
implements VSMParm {
    public static String FORMAL_TYPE = "struct";
    private String formalName;

    public VSMStruct() {
    }

    public VSMParm lastElement() {
        return (VSMParm)this.get(this.size() - 1);
    }

    public VSMStruct(VSMStruct value) {
        this.setValue(value);
    }

    public VSMStruct(VSMStruct value, String formalName) {
        this(value);
        this.formalName = formalName;
    }

    public VSMStruct getValue() {
        return this;
    }

    public final void setValue(VSMStruct value) {
        this.clear();
        if (value != null) {
            this.addAll(value);
        }
    }

    public final void setFormalName(String formalName) {
        this.formalName = formalName;
    }

    @Override
    public String getFormalName() {
        return this.formalName;
    }

    @Override
    public int paramLength() {
        int total = 0;
        for (VSMParm parm : this) {
            total += parm.paramLength();
        }
        return total;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ((VSMParm)i.next()).write(out);
        }
    }

    @Override
    public void read(DataInputStream in, int length) throws IOException, VSMStructStringReadException, VSMException {
        VSMStruct myNewContents = new VSMStruct(null);
        Iterator i = this.iterator();
        while (i.hasNext() && length > 0) {
            VSMParm model = (VSMParm)i.next();
            VSMParm member = model.copyOf();
            member.read(in, length);
            myNewContents.add(member);
            length -= member.paramLength();
        }
        this.setValue(myNewContents);
    }

    @Override
    public VSMParm copyOf() {
        VSMStruct proto = new VSMStruct();
        proto.setFormalName(this.getFormalName());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            proto.add(((VSMParm)it.next()).copyOf());
        }
        return proto;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VSMStruct " + super.toString());
        sb.append(" Formal Name == ").append(this.getFormalName()).append(" Formal Type == ").append(this.getFormalType());
        return sb.toString();
    }

    @Override
    public String getFormalType() {
        return FORMAL_TYPE;
    }

    @Override
    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormalName()).append("(").append(this.getFormalType()).append("):\n");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            sb.append("  ").append(((VSMParm)it.next()).prettyPrint()).append("\n");
        }
        return sb.toString();
    }

    public class VSMStructStructReadException
    extends VSMException {
        public VSMStructStructReadException(String message) {
            super(message);
        }
    }

    public class VSMStructStringReadException
    extends VSMException {
        public VSMStructStringReadException(String message) {
            super(message);
        }
    }
}

