/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.functions;

import com.softwoehr.pigiron.access.CountedString;
import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt1;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMString;
import com.softwoehr.pigiron.access.paramstructs.CpuInfoArray;
import com.softwoehr.pigiron.access.paramstructs.DeviceInfoArray;
import com.softwoehr.pigiron.functions.VSMCall;
import java.io.IOException;

public class ImageActiveConfigurationQuery
extends VSMCall {
    public static final String FUNCTION_NAME = "Image_Active_Configuration_Query";
    public static final int MEMORY_UNIT_KB = 1;
    public static final int MEMORY_UNIT_MB = 2;
    public static final int MEMORY_UNIT_GB = 3;
    public static final int SHARE_TYPE_RELATIVE = 1;
    public static final int SHARE_TYPE_ABSOLUTE = 2;

    public ImageActiveConfigurationQuery() {
    }

    public ImageActiveConfigurationQuery(String hostname, int port, String userid, String password, String target_identifier) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setUserid(userid);
        this.setPassword(password);
        this.setTarget_identifier(target_identifier);
    }

    @Override
    protected ParameterArray composeInputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        VSMString tempString = new VSMString(this.getFunctionName(), this.getFunctionName());
        parameterArray.add(new VSMInt4(tempString.paramLength(), "function_name_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getUserid(), "authenticated_userid");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "authenticated_userid_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getPassword(), "password");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "password_length"));
        parameterArray.add(tempString);
        parameterArray.add(new CountedString(this.getTarget_identifier(), "target_identifier"));
        VSMInt4 outputLength = new VSMInt4(new Long(parameterArray.totalParameterLength()).intValue(), "output_length");
        parameterArray.add(0, outputLength);
        this.setInParams(parameterArray);
        return parameterArray;
    }

    @Override
    protected ParameterArray composeOutputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        parameterArray.add(new VSMInt4(-1, "request_id_immediate"));
        parameterArray.add(new VSMInt4(-1, "output_length"));
        parameterArray.add(new VSMInt4(-1, "request_id"));
        parameterArray.add(new VSMInt4(-1, "return_code"));
        parameterArray.add(new VSMInt4(-1, "reason_code"));
        parameterArray.add(new VSMInt4(-1, "memory_size"));
        parameterArray.add(new VSMInt1(0, "memory_unit"));
        parameterArray.add(new VSMInt1(0, "share_type"));
        parameterArray.add(new CountedString("", "share_value"));
        parameterArray.add(new VSMInt4(-1, "number_CPUs"));
        parameterArray.add(CpuInfoArray.modelArray("cpu_info_array"));
        parameterArray.add(DeviceInfoArray.modelArray("device_info_array"));
        this.setOutParams(parameterArray);
        return parameterArray;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public static void main(String[] argv) throws IOException, VSMException {
        if (argv.length != 5) {
            System.out.println("usage: args are:\ninetaddr port user pw target_id");
            System.exit(1);
        }
        System.out.println("Args are: " + argv[0] + " " + argv[1] + " " + argv[2] + " " + argv[3] + " " + argv[4]);
        ImageActiveConfigurationQuery instance = new ImageActiveConfigurationQuery(argv[0], Integer.valueOf(argv[1]), argv[2], argv[3], argv[4]);
        ParameterArray pA = instance.doIt();
        System.out.println("Returns from call to " + instance.getFunctionName() + ":");
        System.out.println(pA.prettyPrintAll());
    }
}

