/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.functions;

import com.softwoehr.pigiron.access.CountedString;
import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt1;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMString;
import com.softwoehr.pigiron.functions.VSMCall;
import java.io.IOException;

public class ImageCPUQueryDM
extends VSMCall {
    public static final String FUNCTION_NAME = "Image_CPU_Query_DM";
    public static final int BASE_CPU_UNSPECIFIED = 0;
    public static final int BASE_CPU_BASE = 1;
    public static final int DEDICATE_CPU_UNSPECIFIED = 0;
    public static final int DEDICATE_CPU_NODEDICATE = 1;
    public static final int DEDICATE_CPU_DEDICATE = 2;
    public static final int CRYPTO_UNSPECIFIED = 0;
    public static final int CRYPTO_CRYPTO = 1;
    private String cpuAddress = "";

    public ImageCPUQueryDM() {
    }

    public ImageCPUQueryDM(String hostname, int port, String userid, String password, String target_identifier, String cpu_address) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setUserid(userid);
        this.setPassword(password);
        this.setTarget_identifier(target_identifier);
        this.set_cpuAddress(cpu_address);
    }

    public final void set_cpuAddress(String val) {
        this.cpuAddress = val;
    }

    public String get_cpuAddress() {
        return this.cpuAddress;
    }

    @Override
    protected ParameterArray composeInputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        VSMString tempString = new VSMString(this.getFunctionName(), this.getFunctionName());
        parameterArray.add(new VSMInt4(tempString.paramLength(), "function_name_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getUserid(), "authenticated_userid");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "authenticated_userid_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getPassword(), "password");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "password_length"));
        parameterArray.add(tempString);
        parameterArray.add(new CountedString(this.getTarget_identifier(), "target_identifier"));
        parameterArray.add(new CountedString(this.get_cpuAddress(), "cpu_address"));
        VSMInt4 outputLength = new VSMInt4(new Long(parameterArray.totalParameterLength()).intValue(), "output_length");
        parameterArray.add(0, outputLength);
        this.setInParams(parameterArray);
        return parameterArray;
    }

    @Override
    protected ParameterArray composeOutputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        parameterArray.add(new VSMInt4(-1, "request_id_immediate"));
        parameterArray.add(new VSMInt4(-1, "output_length"));
        parameterArray.add(new VSMInt4(-1, "request_id"));
        parameterArray.add(new VSMInt4(-1, "return_code"));
        parameterArray.add(new VSMInt4(-1, "reason_code"));
        parameterArray.add(new CountedString("", "cpu_address"));
        parameterArray.add(new VSMInt1(0, "base_cpu"));
        parameterArray.add(new CountedString("", "cpuid"));
        parameterArray.add(new VSMInt1(0, "dedicate_cpu"));
        parameterArray.add(new VSMInt1(0, "crypto"));
        this.setOutParams(parameterArray);
        return parameterArray;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public static void main(String[] argv) throws IOException, VSMException {
        ImageCPUQueryDM instance = null;
        if (argv.length != 6) {
            System.out.println("usage: args are:\ninetaddr port user pw target_id cpu_address");
            System.exit(1);
        }
        System.out.println("Args are: " + argv[0] + " " + argv[1] + " " + argv[2] + " " + argv[3] + " " + argv[4] + " " + argv[5]);
        instance = new ImageCPUQueryDM(argv[0], Integer.valueOf(argv[1]), argv[2], argv[3], argv[4], argv[5]);
        ParameterArray pA = instance.doIt();
        System.out.println("Returns from call to " + instance.getFunctionName() + ":");
        System.out.println(pA.prettyPrintAll());
    }
}

